/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import java.util.LinkedList;
import java.util.logging.Level;

public class MDTransformer {
    private final LinkedList<MDTransformationRule> transformationRules = new LinkedList();
    private final Operator operator;

    public MDTransformer(Operator op) {
        this.operator = op;
    }

    public void transformMetaData() {
        for (MDTransformationRule rule : this.transformationRules) {
            try {
                rule.transformMD();
            }
            catch (Exception e) {
                this.operator.getLogger().log(Level.WARNING, "Error during meta data transformation: " + e, e);
                this.operator.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.operator.getPortOwner(), "exception_transforming_metadata", e.toString()));
            }
        }
    }

    public void addRule(MDTransformationRule rule) {
        this.transformationRules.add(rule);
    }

    public void addPassThroughRule(InputPort input, OutputPort output) {
        this.addRule(new PassThroughRule(input, output, false));
    }

    public void addGenerationRule(OutputPort output, Class<? extends IOObject> clazz) {
        this.addRule(new GenerateNewMDRule(output, clazz));
    }

    public void clearRules() {
        this.transformationRules.clear();
    }

    public void addRuleAtBeginning(MDTransformationRule mdTransformationRule) {
        this.transformationRules.addFirst(mdTransformationRule);
    }
}

