/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.tools.Tools;
import java.io.Serializable;

public abstract class MDNumber<T extends Number>
implements Serializable,
Comparable<MDNumber<T>> {
    private static final long serialVersionUID = 1L;
    private Relation relation = Relation.UNKNOWN;
    private T number;

    public MDNumber() {
        this.relation = Relation.UNKNOWN;
        this.setNumber(null);
    }

    protected MDNumber(MDNumber<T> other) {
        this.setNumber(other.getNumber());
        this.relation = other.relation;
    }

    public MDNumber(T number) {
        this.setNumber(number);
        this.relation = Relation.EQUAL;
    }

    public MetaDataInfo equals(T value) {
        if (this.relation == Relation.EQUAL && this.getNumber().equals(value)) {
            return MetaDataInfo.YES;
        }
        return MetaDataInfo.UNKNOWN;
    }

    public MetaDataInfo isAtMost(T value) {
        switch (this.relation) {
            case AT_LEAST: {
                return MetaDataInfo.UNKNOWN;
            }
            case EQUAL: {
                if (((Number)this.getNumber()).doubleValue() <= ((Number)value).doubleValue()) {
                    return MetaDataInfo.YES;
                }
                return MetaDataInfo.NO;
            }
            case AT_MOST: {
                if (((Number)this.getNumber()).doubleValue() <= ((Number)value).doubleValue()) {
                    return MetaDataInfo.YES;
                }
                return MetaDataInfo.UNKNOWN;
            }
        }
        return MetaDataInfo.UNKNOWN;
    }

    public MetaDataInfo isAtLeast(T value) {
        switch (this.relation) {
            case AT_MOST: {
                return MetaDataInfo.UNKNOWN;
            }
            case EQUAL: {
                if (((Number)this.getNumber()).doubleValue() >= ((Number)value).doubleValue()) {
                    return MetaDataInfo.YES;
                }
                return MetaDataInfo.NO;
            }
            case AT_LEAST: {
                if (((Number)this.getNumber()).doubleValue() >= ((Number)value).doubleValue()) {
                    return MetaDataInfo.YES;
                }
                return MetaDataInfo.UNKNOWN;
            }
        }
        return MetaDataInfo.UNKNOWN;
    }

    public void increaseByUnknownAmount() {
        switch (this.relation) {
            case AT_MOST: {
                this.relation = Relation.UNKNOWN;
                break;
            }
            case EQUAL: {
                this.relation = Relation.AT_LEAST;
                break;
            }
        }
    }

    public void reduceByUnknownAmount() {
        switch (this.relation) {
            case AT_LEAST: {
                this.relation = Relation.UNKNOWN;
                break;
            }
            case EQUAL: {
                this.relation = Relation.AT_MOST;
                break;
            }
        }
    }

    public boolean isKnown() {
        return this.relation == Relation.EQUAL;
    }

    public void setUnkown() {
        this.relation = Relation.UNKNOWN;
    }

    public T getValue() {
        if (this.isKnown()) {
            return this.getNumber();
        }
        throw new IllegalStateException("Value is currently not exactly known.");
    }

    public Relation getRelation() {
        return this.relation;
    }

    public String toString() {
        switch (this.relation) {
            case EQUAL: {
                return "=" + Tools.formatNumber(((Number)this.getNumber()).doubleValue(), 3);
            }
            case AT_LEAST: {
                return "\u2265" + Tools.formatNumber(((Number)this.getNumber()).doubleValue(), 3);
            }
            case AT_MOST: {
                return "\u2264" + Tools.formatNumber(((Number)this.getNumber()).doubleValue(), 3);
            }
        }
        return "?";
    }

    public abstract MDNumber<T> copy();

    protected void setNumber(T number) {
        this.number = number;
    }

    public T getNumber() {
        return this.number;
    }

    public abstract MDNumber<T> add(T var1);

    public abstract MDNumber<T> multiply(double var1);

    @Override
    public int compareTo(MDNumber<T> other) {
        return (int)Math.signum(((Number)this.number).doubleValue() - ((Number)other.number).doubleValue());
    }

    public static enum Relation {
        AT_LEAST,
        EQUAL,
        AT_MOST,
        UNKNOWN;

    }
}

