/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.ports.metadata.MDNumber;

public class MDInteger
extends MDNumber<Integer> {
    private static final long serialVersionUID = 1L;

    public MDInteger() {
        super(0);
    }

    public MDInteger(int i) {
        super(i);
    }

    public MDInteger(MDInteger integer) {
        super(integer);
    }

    public MDInteger add(Integer add) {
        this.setNumber((Integer)this.getNumber() + add);
        return this;
    }

    public void add(MDInteger add) {
        this.setNumber((Integer)this.getNumber() + (Integer)add.getNumber());
        switch (add.getRelation()) {
            case AT_LEAST: {
                this.increaseByUnknownAmount();
                break;
            }
            case AT_MOST: {
                this.reduceByUnknownAmount();
                break;
            }
            case UNKNOWN: {
                this.setUnkown();
            }
        }
    }

    public MDInteger multiply(double factor) {
        Integer current = (Integer)this.getNumber();
        if (current != null) {
            this.setNumber((int)Math.round((double)current.intValue() * factor));
        }
        return this;
    }

    public MDInteger subtract(int subtrahend) {
        Integer current = (Integer)this.getNumber();
        if (current != null) {
            this.setNumber(current - subtrahend);
        }
        return this;
    }

    public MDInteger copy() {
        return new MDInteger(this);
    }

    @Override
    public String toString() {
        switch (this.getRelation()) {
            case EQUAL: {
                return "= " + this.getValue();
            }
            case AT_LEAST: {
                return "\u2265 " + this.getNumber();
            }
            case AT_MOST: {
                return "\u2264 " + this.getNumber();
            }
        }
        return "?";
    }
}

