/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.learner.CapabilityProvider;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.Binary2MultiClassLearner;
import com.rapidminer.operator.learner.meta.ClassificationByRegression;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.CapabilityPrecondition;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PredictionModelMetaData;
import com.rapidminer.operator.ports.quickfix.OperatorInsertionQuickFix;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.tools.OperatorService;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class LearnerPrecondition
extends CapabilityPrecondition {
    public LearnerPrecondition(CapabilityProvider capabilityProvider, InputPort inputPort) {
        super(capabilityProvider, inputPort);
    }

    @Override
    public void makeAdditionalChecks(ExampleSetMetaData metaData) {
        super.makeAdditionalChecks(metaData);
    }

    @Override
    protected Collection<QuickFix> getFixesForClassificationWhenRegressionSupported() {
        Operator learner = this.getInputPort().getPorts().getOwner().getOperator();
        OperatorDescription[] ods = OperatorService.getOperatorDescriptions(ClassificationByRegression.class);
        String name = null;
        if (ods.length > 0) {
            name = ods[0].getName();
        }
        OperatorInsertionQuickFix fix = new OperatorInsertionQuickFix("insert_classification_by_regression_learner", new Object[]{name, learner.getOperatorDescription().getName()}, 3, this.getInputPort()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void apply() {
                LinkedList<Port> toUnlock = new LinkedList<Port>();
                try {
                    InputPort inputPort;
                    Operator learner = LearnerPrecondition.this.getInputPort().getPorts().getOwner().getOperator();
                    ExecutionUnit learnerUnit = learner.getExecutionUnit();
                    OutputPort modelOutput = null;
                    PredictionModelMetaData modelMetaData = new PredictionModelMetaData((Class<? extends PredictionModel>)PredictionModel.class, new ExampleSetMetaData());
                    for (OutputPort port : learner.getOutputPorts().getAllPorts()) {
                        MetaData data = port.getMetaData();
                        if (!modelMetaData.isCompatible(data, CompatibilityLevel.VERSION_5)) continue;
                        modelOutput = port;
                        toUnlock.add(modelOutput);
                        modelOutput.lock();
                        break;
                    }
                    ClassificationByRegression metaLearner = OperatorService.createOperator(ClassificationByRegression.class);
                    learnerUnit.addOperator((Operator)metaLearner, learnerUnit.getIndexOfOperator(learner));
                    OutputPort output = LearnerPrecondition.this.getInputPort().getSource();
                    toUnlock.add(output);
                    output.lock();
                    output.disconnect();
                    output.connectTo(metaLearner.getTrainingSetInputPort());
                    if (modelOutput != null && (inputPort = modelOutput.getDestination()) != null) {
                        toUnlock.add(inputPort);
                        inputPort.lock();
                        modelOutput.disconnect();
                        metaLearner.getModelOutputPort().connectTo(inputPort);
                    }
                    learner.remove();
                    metaLearner.getSubprocess(0).addOperator(learner);
                    ((OutputPort)metaLearner.getSubprocess(0).getInnerSources().getPortByIndex(0)).connectTo(LearnerPrecondition.this.getInputPort());
                    if (modelOutput != null) {
                        modelOutput.connectTo(metaLearner.getInnerModelSink());
                    }
                }
                catch (OperatorCreationException ex) {
                    for (Port port : toUnlock) {
                        port.unlock();
                    }
                }
                finally {
                    for (Port port : toUnlock) {
                        port.unlock();
                    }
                }
            }

            @Override
            public Operator createOperator() throws OperatorCreationException {
                return null;
            }
        };
        return Collections.singletonList(fix);
    }

    @Override
    protected Collection<QuickFix> getFixesForPolynomialClassificationWhenBinominalSupported() {
        Operator learner = this.getInputPort().getPorts().getOwner().getOperator();
        OperatorDescription[] ods = OperatorService.getOperatorDescriptions(Binary2MultiClassLearner.class);
        String name = null;
        if (ods.length > 0) {
            name = ods[0].getName();
        }
        OperatorInsertionQuickFix fix = new OperatorInsertionQuickFix("insert_binominal_to_multiclass_learner", new Object[]{name, learner.getOperatorDescription().getName()}, 8, this.getInputPort()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void apply() {
                LinkedList<Port> toUnlock = new LinkedList<Port>();
                try {
                    InputPort inputPort;
                    Operator learner = LearnerPrecondition.this.getInputPort().getPorts().getOwner().getOperator();
                    ExecutionUnit learnerUnit = learner.getExecutionUnit();
                    OutputPort modelOutput = null;
                    PredictionModelMetaData modelMetaData = new PredictionModelMetaData((Class<? extends PredictionModel>)PredictionModel.class, new ExampleSetMetaData());
                    for (OutputPort port : learner.getOutputPorts().getAllPorts()) {
                        MetaData data = port.getMetaData();
                        if (!modelMetaData.isCompatible(data, CompatibilityLevel.VERSION_5)) continue;
                        modelOutput = port;
                        toUnlock.add(modelOutput);
                        modelOutput.lock();
                        break;
                    }
                    Binary2MultiClassLearner metaLearner = OperatorService.createOperator(Binary2MultiClassLearner.class);
                    learnerUnit.addOperator((Operator)metaLearner, learnerUnit.getIndexOfOperator(learner));
                    OutputPort output = LearnerPrecondition.this.getInputPort().getSource();
                    toUnlock.add(output);
                    output.lock();
                    output.disconnect();
                    output.connectTo(metaLearner.getTrainingSetInputPort());
                    if (modelOutput != null && (inputPort = modelOutput.getDestination()) != null) {
                        toUnlock.add(inputPort);
                        inputPort.lock();
                        modelOutput.disconnect();
                        metaLearner.getModelOutputPort().connectTo(inputPort);
                    }
                    learner.remove();
                    metaLearner.getSubprocess(0).addOperator(learner);
                    ((OutputPort)metaLearner.getSubprocess(0).getInnerSources().getPortByIndex(0)).connectTo(LearnerPrecondition.this.getInputPort());
                    if (modelOutput != null) {
                        modelOutput.connectTo(metaLearner.getInnerModelSink());
                    }
                }
                catch (OperatorCreationException ex) {
                    for (Port port : toUnlock) {
                        port.unlock();
                    }
                }
                finally {
                    for (Port port : toUnlock) {
                        port.unlock();
                    }
                }
            }

            @Override
            public Operator createOperator() throws OperatorCreationException {
                return null;
            }
        };
        return Collections.singletonList(fix);
    }
}

