/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.quickfix.AddCompatibleOperatorQuickFix;
import com.rapidminer.operator.ports.quickfix.ConnectToQuickFix;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import java.util.LinkedList;
import java.util.List;

public class InputMissingMetaDataError
extends SimpleMetaDataError {
    private InputPort inputPort;
    private Class<? extends IOObject> desiredClass;

    public InputMissingMetaDataError(InputPort inputPort, Class<? extends IOObject> desiredClazz) {
        this(inputPort, desiredClazz, null);
    }

    public InputMissingMetaDataError(InputPort inputPort, Class<? extends IOObject> desiredClass, Class<? extends IOObject> receivedClass) {
        Object[] objectArray;
        String string = receivedClass == null ? "input_missing" : "expected";
        if (receivedClass == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = inputPort.getSpec();
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = desiredClass.getSimpleName();
            objectArray = objectArray3;
            objectArray3[1] = receivedClass.getSimpleName();
        }
        super(ProcessSetupError.Severity.ERROR, (Port)inputPort, string, objectArray);
        this.inputPort = inputPort;
        this.desiredClass = desiredClass;
    }

    public List<QuickFix> getQuickFixes() {
        LinkedList<QuickFix> fixes = new LinkedList<QuickFix>();
        if (this.desiredClass != null) {
            for (OutputPort outputPort : this.inputPort.getPorts().getOwner().getConnectionContext().getAllOutputPorts()) {
                if (outputPort.isConnected() || outputPort.getMetaData() == null || !this.desiredClass.isAssignableFrom(outputPort.getMetaData().getObjectClass())) continue;
                fixes.add(new ConnectToQuickFix(this.inputPort, outputPort));
            }
            fixes.add(new AddCompatibleOperatorQuickFix(this.inputPort, this.desiredClass));
        }
        return fixes;
    }
}

