/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import java.util.List;

public class FlatteningPassThroughRule
implements MDTransformationRule {
    private final List<InputPort> inputPorts;
    private final OutputPort outputPort;

    public FlatteningPassThroughRule(List<InputPort> inputPorts, OutputPort outputPort) {
        this.inputPorts = inputPorts;
        this.outputPort = outputPort;
    }

    @Override
    public void transformMD() {
        for (InputPort inputPort : this.inputPorts) {
            MetaData metaData = inputPort.getMetaData();
            if (metaData == null) continue;
            if (metaData instanceof CollectionMetaData) {
                metaData = ((CollectionMetaData)metaData).getElementMetaDataRecursive();
            }
            metaData = metaData.clone();
            metaData.addToHistory(this.outputPort);
            this.outputPort.deliverMD(this.modifyMetaData(metaData));
            return;
        }
        this.outputPort.deliverMD(null);
    }

    protected MetaData modifyMetaData(MetaData metaData) {
        return metaData;
    }
}

