/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;

public class ExampleSetUnionRule
implements MDTransformationRule {
    private final InputPort inputPort1;
    private final InputPort inputPort2;
    private final OutputPort outputPort;
    private final String prefixForDuplicates;

    public ExampleSetUnionRule(InputPort inputPort1, InputPort inputPort2, OutputPort outputPort, String prefixForDuplicates) {
        this.inputPort1 = inputPort1;
        this.inputPort2 = inputPort2;
        this.outputPort = outputPort;
        this.prefixForDuplicates = prefixForDuplicates;
    }

    protected String getPrefix() {
        return this.prefixForDuplicates;
    }

    @Override
    public void transformMD() {
        MetaData md1 = this.inputPort1.getMetaData();
        MetaData md2 = this.inputPort2.getMetaData();
        if (md1 != null && md2 != null) {
            if (md1 instanceof ExampleSetMetaData && md2 instanceof ExampleSetMetaData) {
                ExampleSetMetaData emd1 = (ExampleSetMetaData)md1;
                ExampleSetMetaData newEMD = emd1.clone().joinAttributes((ExampleSetMetaData)md2, this.getPrefix());
                for (AttributeMetaData possibleNew : ((ExampleSetMetaData)md2).getAllAttributes()) {
                    if (emd1.containsAttributeName(possibleNew.getName()) == MetaDataInfo.YES) continue;
                    this.transformAddedAttributeMD(newEMD, newEMD.getAttributeByName(possibleNew.getName()));
                }
                this.outputPort.deliverMD(newEMD);
            } else {
                this.outputPort.deliverMD(new ExampleSetMetaData());
            }
        } else {
            this.outputPort.deliverMD(null);
        }
    }

    protected void transformAddedAttributeMD(ExampleSetMetaData emd, AttributeMetaData newAttribute) {
    }
}

