/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AbstractPrecondition;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.InputMissingMetaDataError;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.MetaDataUnderspecifiedError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import java.util.Collections;

public class ExampleSetSizePrecondition
extends AbstractPrecondition {
    private String startParameter;
    private String endParameter;
    private Operator operator;

    public ExampleSetSizePrecondition(InputPort inputPort, Operator operator, String startParameter) {
        this(inputPort, operator, startParameter, null);
    }

    public ExampleSetSizePrecondition(InputPort inputPort, Operator operator, String startParameter, String endParameter) {
        super(inputPort);
        this.startParameter = startParameter;
        this.endParameter = endParameter;
        this.operator = operator;
    }

    @Override
    public void check(MetaData metaData) {
        block9: {
            InputPort inputPort = this.getInputPort();
            if (metaData == null) {
                inputPort.addError(new InputMissingMetaDataError(inputPort, ExampleSet.class, null));
            } else if (metaData instanceof ExampleSetMetaData) {
                ExampleSetMetaData emd = (ExampleSetMetaData)metaData;
                try {
                    int startIndex = this.operator.getParameterAsInt(this.startParameter);
                    if (emd.getNumberOfExamples().isAtLeast(startIndex) == MetaDataInfo.NO) {
                        this.createError(ProcessSetupError.Severity.ERROR, Collections.singletonList(new ParameterSettingQuickFix(this.operator, this.startParameter, (Integer)emd.getNumberOfExamples().getValue() - (this.endParameter == null ? 0 : 1) + "")), "exampleset.parameter_value_exceeds_exampleset_size", this.startParameter, startIndex + "");
                    }
                    if (this.endParameter == null) break block9;
                    int endIndex = this.operator.getParameterAsInt(this.endParameter);
                    if (emd.getNumberOfExamples().isAtLeast(endIndex) == MetaDataInfo.NO) {
                        this.createError(ProcessSetupError.Severity.ERROR, Collections.singletonList(new ParameterSettingQuickFix(this.operator, this.endParameter, emd.getNumberOfExamples().getValue() + "")), "exampleset.parameter_value_exceeds_exampleset_size", this.endParameter, endIndex + "");
                    }
                    if (startIndex > endIndex) {
                        this.operator.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.operator.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix(this.operator, this.endParameter, startIndex + 1 + "")), "parameter_combination_forbidden", this.startParameter, this.endParameter));
                    }
                }
                catch (Exception e) {}
            } else {
                inputPort.addError(new MetaDataUnderspecifiedError(inputPort));
            }
        }
    }

    @Override
    public void assumeSatisfied() {
        this.getInputPort().receiveMD(new ExampleSetMetaData());
    }

    @Override
    public String getDescription() {
        return "<em>expects:</em> ExampleSet";
    }

    @Override
    public boolean isCompatible(MetaData input, CompatibilityLevel level) {
        return ExampleSet.class.isAssignableFrom(input.getObjectClass());
    }

    @Override
    public MetaData getExpectedMetaData() {
        return new ExampleSetMetaData();
    }
}

