/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.ModelApplier;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AbstractPrecondition;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.InputMissingMetaDataError;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.MetaDataUnderspecifiedError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.quickfix.ChangeAttributeRoleQuickFix;
import com.rapidminer.operator.ports.quickfix.OperatorInsertionQuickFix;
import com.rapidminer.operator.preprocessing.IdTagging;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.OperatorService;
import java.util.LinkedList;

public class ExampleSetPrecondition
extends AbstractPrecondition {
    private final String[] requiredSpecials;
    private final int allowedValueTypes;
    private final String[] ignoreForTypeCheck;
    private final int allowedSpecialsValueType;
    private final String[] requiredAttributes;
    private boolean optional = false;

    public ExampleSetPrecondition(InputPort inputPort) {
        this(inputPort, 0, null);
    }

    public ExampleSetPrecondition(InputPort inputPort, int allowedValueTypesForRegularAttributes, String ... requiredSpecials) {
        this(inputPort, new String[0], allowedValueTypesForRegularAttributes, new String[0], 0, requiredSpecials);
    }

    public ExampleSetPrecondition(InputPort inputPort, String[] requiredAttributeNames, int allowedValueTypesForRegular, String ... requiredSpecials) {
        this(inputPort, requiredAttributeNames, allowedValueTypesForRegular, new String[0], 0, requiredSpecials);
    }

    public ExampleSetPrecondition(InputPort inputPort, String requiredSpecials, int allowedValueTypForSpecial) {
        this(inputPort, new String[0], 0, new String[0], allowedValueTypForSpecial, requiredSpecials);
    }

    public ExampleSetPrecondition(InputPort inputPort, String[] requiredAttributeNames, int allowedValueTypesForRegular, String[] ignoreForTypeCheck, int allowedValueTypesForSpecial, String ... requiredSpecials) {
        super(inputPort);
        this.allowedValueTypes = allowedValueTypesForRegular;
        this.requiredSpecials = requiredSpecials;
        this.requiredAttributes = requiredAttributeNames;
        this.allowedSpecialsValueType = allowedValueTypesForSpecial;
        this.ignoreForTypeCheck = ignoreForTypeCheck;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    @Override
    public void assumeSatisfied() {
        this.getInputPort().receiveMD(new ExampleSetMetaData());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(MetaData metaData) {
        InputPort inputPort = this.getInputPort();
        if (metaData == null) {
            if (this.optional) return;
            inputPort.addError(new InputMissingMetaDataError(inputPort, ExampleSet.class, null));
            return;
        } else if (metaData instanceof ExampleSetMetaData) {
            ExampleSetMetaData emd = (ExampleSetMetaData)metaData;
            for (String attributeName : this.requiredAttributes) {
                MetaDataInfo attInfo = emd.containsAttributeName(attributeName);
                if (attInfo != MetaDataInfo.NO) continue;
                this.createError(ProcessSetupError.Severity.WARNING, "missing_attribute", attributeName);
            }
            if (this.allowedValueTypes != 0 && this.allowedValueTypes != -1) {
                for (AttributeMetaData amd : emd.getAllAttributes()) {
                    if (amd.isSpecial()) continue;
                    for (String name : this.ignoreForTypeCheck) {
                        if (!name.equals(amd.getName())) continue;
                    }
                    if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(amd.getValueType(), this.allowedValueTypes)) continue;
                    this.createError(ProcessSetupError.Severity.ERROR, "regular_type_mismatch", Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(this.allowedValueTypes));
                    break;
                }
            }
            if (this.requiredSpecials != null) {
                block10: for (String name : this.requiredSpecials) {
                    MetaDataInfo has = emd.hasSpecial(name);
                    switch (has) {
                        case NO: {
                            OperatorDescription[] ods;
                            LinkedList<OperatorInsertionQuickFix> fixes = new LinkedList<OperatorInsertionQuickFix>();
                            if (name.equals("id")) {
                                ods = OperatorService.getOperatorDescriptions(IdTagging.class);
                                fixes.add(new OperatorInsertionQuickFix("insert_id_tagging", new Object[]{ods[0].getName()}, 10, inputPort){

                                    @Override
                                    public Operator createOperator() throws OperatorCreationException {
                                        return OperatorService.createOperator(IdTagging.class);
                                    }
                                });
                            }
                            if (name.equals("prediction") && (ods = OperatorService.getOperatorDescriptions(ModelApplier.class)).length > 0) {
                                fixes.add(new OperatorInsertionQuickFix("insert_model_applier", new Object[]{ods[0].getName()}, 10, inputPort, 1, 0){

                                    @Override
                                    public Operator createOperator() throws OperatorCreationException {
                                        return OperatorService.createOperator(ModelApplier.class);
                                    }
                                });
                            }
                            fixes.add(new ChangeAttributeRoleQuickFix(inputPort, name, "change_attribute_role", name));
                            if (fixes.size() > 0) {
                                inputPort.addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)inputPort, fixes, "exampleset.missing_role", name));
                                continue block10;
                            }
                            this.createError(ProcessSetupError.Severity.ERROR, "special_missing", name);
                            continue block10;
                        }
                        case UNKNOWN: {
                            this.createError(ProcessSetupError.Severity.WARNING, "special_unknown", name);
                            continue block10;
                        }
                        case YES: {
                            AttributeMetaData amd = emd.getSpecial(name);
                            if (amd == null || Ontology.ATTRIBUTE_VALUE_TYPE.isA(amd.getValueType(), this.allowedSpecialsValueType)) continue block10;
                            this.createError(ProcessSetupError.Severity.ERROR, "special_attribute_has_wrong_type", amd.getName(), name, Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(this.allowedSpecialsValueType));
                        }
                    }
                }
            }
            try {
                this.makeAdditionalChecks(emd);
                return;
            }
            catch (UndefinedParameterError e) {}
            return;
        } else {
            inputPort.addError(new MetaDataUnderspecifiedError(inputPort));
        }
    }

    public void makeAdditionalChecks(ExampleSetMetaData emd) throws UndefinedParameterError {
    }

    @Override
    public String getDescription() {
        return "<em>expects:</em> ExampleSet";
    }

    @Override
    public boolean isCompatible(MetaData input, CompatibilityLevel level) {
        return ExampleSet.class.isAssignableFrom(input.getObjectClass());
    }

    @Override
    public MetaData getExpectedMetaData() {
        return new ExampleSetMetaData();
    }
}

