/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ExampleSetMetaData
extends MetaData {
    private static final long serialVersionUID = 1L;
    private SetRelation attributesRelation = SetRelation.EQUAL;
    private MDInteger numberOfExamples = new MDInteger();
    private Map<String, AttributeMetaData> attributeMetaData = new LinkedHashMap<String, AttributeMetaData>();
    private boolean nominalDataWasShrinked = false;

    public ExampleSetMetaData() {
        super(ExampleSet.class);
    }

    public ExampleSetMetaData(Map<String, Object> keyValueMap) {
        super(ExampleSet.class, keyValueMap);
    }

    public ExampleSetMetaData(String key, Object value) {
        super(ExampleSet.class, key, value);
    }

    public ExampleSetMetaData(List<AttributeMetaData> attributeMetaData) {
        super(ExampleSet.class);
        this.addAllAttributes(attributeMetaData);
    }

    public ExampleSetMetaData(ExampleSet exampleSet) {
        this(exampleSet, false);
    }

    public ExampleSetMetaData(ExampleSet exampleSet, boolean shortened) {
        super(ExampleSet.class);
        int maxNumber = Integer.MAX_VALUE;
        if (shortened) {
            maxNumber = ExampleSetMetaData.getMaximumNumberOfAttributes();
        } else {
            exampleSet.recalculateAllAttributeStatistics();
        }
        Iterator<AttributeRole> i = exampleSet.getAttributes().allAttributeRoles();
        while (i.hasNext()) {
            AttributeRole role = i.next();
            this.addAttribute(new AttributeMetaData(role, exampleSet, shortened));
            if (--maxNumber != 0) continue;
            break;
        }
        this.numberOfExamples = new MDInteger(exampleSet.size());
    }

    public AttributeMetaData getAttributeByName(String name) {
        return this.attributeMetaData.get(name);
    }

    public AttributeMetaData getAttributeByRole(String role) {
        for (AttributeMetaData amd : this.attributeMetaData.values()) {
            String currentRole = amd.getRole();
            if (currentRole == null || !currentRole.equals(role)) continue;
            return amd;
        }
        return null;
    }

    public void addAllAttributes(Collection<AttributeMetaData> attributes) {
        for (AttributeMetaData amd : attributes) {
            this.addAttribute(amd);
        }
    }

    public Collection<AttributeMetaData> getAllAttributes() {
        return this.attributeMetaData.values();
    }

    public void removeAttribute(AttributeMetaData attribute) {
        this.attributeMetaData.remove(attribute.getName());
    }

    public void addAttribute(AttributeMetaData attribute) {
        if (this.attributeMetaData == null) {
            this.attributeMetaData = new LinkedHashMap<String, AttributeMetaData>();
        }
        attribute = attribute.registerOwner(this);
        this.attributeMetaData.put(attribute.getName(), attribute);
    }

    @Override
    public String getDescription() {
        StringBuilder buf = new StringBuilder(super.getDescription());
        buf.append("<br/>Number of examples ");
        buf.append(this.numberOfExamples.toString());
        if (this.attributeMetaData != null) {
            buf.append("<br/>");
            switch (this.attributesRelation) {
                case SUBSET: {
                    buf.append("At most ");
                    break;
                }
                case SUPERSET: {
                    buf.append("At least ");
                }
            }
            buf.append(this.attributeMetaData.size());
            buf.append(" attribute" + (this.attributeMetaData.size() != 1 ? "s" : "") + ": ");
            buf.append("<table><thead><tr><th>Role</th><th>Name</th><th>Type</th><th>Range</th><th>Missings</th><th>Comment</th></tr></thead><tbody>");
            for (AttributeMetaData amd : this.attributeMetaData.values()) {
                buf.append(amd.getDescriptionAsTableRow());
            }
            buf.append("</tbody></table>");
        }
        return buf.toString();
    }

    public void setAttributes(List<AttributeMetaData> attributes) {
        this.attributeMetaData.clear();
        this.addAllAttributes(attributes);
    }

    @Override
    public ExampleSetMetaData clone() {
        ExampleSetMetaData clone = (ExampleSetMetaData)super.clone();
        clone.attributesRelation = this.attributesRelation;
        clone.numberOfExamples = this.numberOfExamples.copy();
        if (this.attributeMetaData != null) {
            clone.attributeMetaData = new LinkedHashMap<String, AttributeMetaData>();
            for (AttributeMetaData attribute : this.attributeMetaData.values()) {
                clone.addAttribute(attribute.clone());
            }
        }
        clone.nominalDataWasShrinked = this.nominalDataWasShrinked;
        return clone;
    }

    public MetaDataInfo containsAttributesWithValueType(int type, boolean includeSpecials) {
        if (this.attributeMetaData != null) {
            for (AttributeMetaData amd : this.attributeMetaData.values()) {
                SetRelation relation;
                if (amd.isSpecial()) {
                    if (!includeSpecials) continue;
                    relation = this.attributesRelation;
                } else {
                    relation = this.attributesRelation;
                }
                if (amd.getRole() != null || !Ontology.ATTRIBUTE_VALUE_TYPE.isA(amd.getValueType(), type)) continue;
                if (relation == SetRelation.EQUAL || relation == SetRelation.SUPERSET) {
                    return MetaDataInfo.YES;
                }
                return MetaDataInfo.UNKNOWN;
            }
            if (this.attributesRelation == SetRelation.SUPERSET || this.attributesRelation == SetRelation.UNKNOWN) {
                return MetaDataInfo.UNKNOWN;
            }
            return MetaDataInfo.NO;
        }
        return MetaDataInfo.UNKNOWN;
    }

    public AttributeMetaData getSpecial(String role) {
        if (this.attributeMetaData != null) {
            for (AttributeMetaData amd : this.attributeMetaData.values()) {
                if (!role.equals(amd.getRole())) continue;
                return amd;
            }
        }
        return null;
    }

    public AttributeMetaData getLabelMetaData() {
        return this.getSpecial("label");
    }

    public MetaDataInfo hasSpecial(String role) {
        if (this.attributeMetaData == null) {
            return MetaDataInfo.UNKNOWN;
        }
        if (role.equals("confidence")) {
            for (AttributeMetaData amd : this.attributeMetaData.values()) {
                String currentRole = amd.getRole();
                if (currentRole == null || !currentRole.startsWith(role)) continue;
                return MetaDataInfo.YES;
            }
        } else {
            for (AttributeMetaData amd : this.attributeMetaData.values()) {
                if (!role.equals(amd.getRole())) continue;
                return MetaDataInfo.YES;
            }
        }
        switch (this.attributesRelation) {
            case SUBSET: {
                return MetaDataInfo.UNKNOWN;
            }
            case SUPERSET: 
            case EQUAL: {
                return MetaDataInfo.NO;
            }
        }
        return MetaDataInfo.UNKNOWN;
    }

    public ExampleSetMetaData joinAttributes(ExampleSetMetaData es2, String prefixForDuplicates) {
        ExampleSetMetaData result = this.clone();
        if (this.attributeMetaData == null || es2.attributeMetaData == null) {
            return result;
        }
        for (AttributeMetaData a : es2.attributeMetaData.values()) {
            AttributeMetaData clone = a.clone();
            if (a.getRole() != null && a.getRole().equals("id")) continue;
            switch (result.containsAttributeName(a.getName())) {
                case YES: {
                    if (prefixForDuplicates == null) break;
                    clone.setName(a.getName() + prefixForDuplicates);
                    result.attributeMetaData.put(clone.getName(), clone);
                    break;
                }
                case NO: {
                    result.attributeMetaData.put(clone.getName(), clone);
                    break;
                }
                case UNKNOWN: {
                    result.attributeMetaData.put(clone.getName(), clone);
                    result.attributesAreSubset();
                }
            }
        }
        result.attributesRelation = this.attributesRelation == SetRelation.EQUAL && es2.attributesRelation == SetRelation.EQUAL ? SetRelation.EQUAL : (es2.attributesRelation == SetRelation.SUPERSET || this.attributesRelation == SetRelation.SUPERSET ? SetRelation.SUPERSET : SetRelation.UNKNOWN);
        return result;
    }

    public MetaDataInfo containsAttributeName(String name) {
        if (this.attributeMetaData != null) {
            boolean contains = this.attributeMetaData.containsKey(name);
            switch (this.attributesRelation) {
                case EQUAL: {
                    return contains ? MetaDataInfo.YES : MetaDataInfo.NO;
                }
                case SUPERSET: {
                    return contains ? MetaDataInfo.YES : MetaDataInfo.UNKNOWN;
                }
                case SUBSET: {
                    return contains ? MetaDataInfo.UNKNOWN : MetaDataInfo.NO;
                }
            }
            return MetaDataInfo.UNKNOWN;
        }
        return MetaDataInfo.UNKNOWN;
    }

    public MetaDataInfo containsSpecialAttribute(String role) {
        if (this.attributeMetaData != null) {
            boolean contains = false;
            for (AttributeMetaData amd : this.getAllAttributes()) {
                String itsRole = amd.getRole();
                if (itsRole == null || !itsRole.equals(role)) continue;
                contains = true;
            }
            switch (this.attributesRelation) {
                case EQUAL: {
                    return contains ? MetaDataInfo.YES : MetaDataInfo.NO;
                }
                case SUPERSET: {
                    return contains ? MetaDataInfo.YES : MetaDataInfo.UNKNOWN;
                }
                case SUBSET: {
                    return contains ? MetaDataInfo.UNKNOWN : MetaDataInfo.NO;
                }
            }
            return MetaDataInfo.UNKNOWN;
        }
        return MetaDataInfo.UNKNOWN;
    }

    public void mergeSetRelation(SetRelation relation) {
        this.attributesRelation = this.attributesRelation.merge(relation);
    }

    public SetRelation getAttributeSetRelation() {
        return this.attributesRelation;
    }

    public void attributesAreKnown() {
        this.attributesRelation = SetRelation.EQUAL;
    }

    public void attributesAreSuperset() {
        this.mergeSetRelation(SetRelation.SUPERSET);
    }

    public void attributesAreSubset() {
        this.mergeSetRelation(SetRelation.SUBSET);
    }

    public void setNumberOfExamples(int num) {
        this.numberOfExamples = new MDInteger(num);
    }

    public void setNumberOfExamples(MDInteger num) {
        this.numberOfExamples = num;
    }

    public void numberOfExamplesIsUnkown() {
        this.numberOfExamples.setUnkown();
    }

    public MDInteger getNumberOfExamples() {
        return this.numberOfExamples;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ExampleSetMetaData: #examples: " + this.numberOfExamples + "; #attributes: " + this.getAllAttributes().size() + Tools.getLineSeparator());
        for (AttributeMetaData amd : this.getAllAttributes()) {
            buffer.append(amd.toString() + Tools.getLineSeparator());
        }
        return buffer.toString();
    }

    public MetaData transpose() {
        ExampleSetMetaData transposedMD = new ExampleSetMetaData();
        transposedMD.addAttribute(new AttributeMetaData("id", 1, "id"));
        if (this.numberOfExamples.isKnown()) {
            int type;
            int num = (Integer)this.numberOfExamples.getValue();
            switch (this.containsAttributesWithValueType(1, true)) {
                case YES: {
                    type = 1;
                    break;
                }
                case NO: {
                    type = 4;
                    break;
                }
                default: {
                    type = 0;
                }
            }
            for (int i = 0; i < num; ++i) {
                transposedMD.addAttribute(new AttributeMetaData("att_" + (i + 1), type));
            }
        } else {
            transposedMD.attributesAreSuperset();
        }
        transposedMD.numberOfExamples = new MDInteger(this.attributeMetaData.size());
        switch (this.attributesRelation) {
            case EQUAL: {
                break;
            }
            case SUBSET: {
                transposedMD.numberOfExamples.reduceByUnknownAmount();
                break;
            }
            case SUPERSET: {
                transposedMD.numberOfExamples.increaseByUnknownAmount();
                break;
            }
            case UNKNOWN: {
                transposedMD.numberOfExamples = new MDInteger();
            }
        }
        return transposedMD;
    }

    public void clearRegular() {
        Iterator<AttributeMetaData> iterator = this.getAllAttributes().iterator();
        while (iterator.hasNext()) {
            AttributeMetaData amd = iterator.next();
            if (amd.isSpecial()) continue;
            iterator.remove();
        }
    }

    public void clear() {
        this.getAllAttributes().clear();
    }

    public int getNumberOfRegularAttributes() {
        int regular = 0;
        for (AttributeMetaData amd : this.getAllAttributes()) {
            if (amd.isSpecial()) continue;
            ++regular;
        }
        return regular;
    }

    public MetaDataInfo equalHeader(ExampleSetMetaData other) {
        if (other == this) {
            return MetaDataInfo.YES;
        }
        if (other.getAllAttributes().size() != this.getAllAttributes().size() && other.getAttributeSetRelation() == SetRelation.EQUAL && this.getAttributeSetRelation() == SetRelation.EQUAL) {
            return MetaDataInfo.NO;
        }
        if (other.getAllAttributes().size() == this.getAllAttributes().size() && other.getAttributeSetRelation() == SetRelation.EQUAL && this.getAttributeSetRelation() == SetRelation.EQUAL) {
            for (AttributeMetaData amd : this.getAllAttributes()) {
                AttributeMetaData otherAMD = other.getAttributeByName(amd.getName());
                if (otherAMD == null) {
                    return MetaDataInfo.NO;
                }
                String otherRole = otherAMD.getRole();
                if (otherRole != null && !otherAMD.getRole().equals(amd.getRole())) {
                    return MetaDataInfo.NO;
                }
                if (otherAMD.getValueType() == amd.getValueType()) continue;
                return MetaDataInfo.NO;
            }
            return MetaDataInfo.YES;
        }
        return MetaDataInfo.UNKNOWN;
    }

    public Collection<String> getAttributeNamesByType(int mustBeOfType) {
        LinkedList<String> names = new LinkedList<String>();
        for (AttributeMetaData attribute : this.getAllAttributes()) {
            if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), mustBeOfType)) continue;
            names.add(attribute.getName());
        }
        return names;
    }

    public String getShortDescription() {
        StringBuilder buf = new StringBuilder(super.getDescription());
        buf.append("<br/>Number of examples ");
        buf.append(this.numberOfExamples.toString());
        if (this.attributeMetaData != null) {
            buf.append("<br/>");
            switch (this.attributesRelation) {
                case SUBSET: {
                    buf.append("At most ");
                    break;
                }
                case SUPERSET: {
                    buf.append("At least ");
                }
            }
            buf.append(this.attributeMetaData.size());
            buf.append(" attribute" + (this.attributeMetaData.size() != 1 ? "s" : "") + ": ");
        }
        if (this.nominalDataWasShrinked) {
            buf.append("<br/><small><strong>Note:</strong> Some of the nominal values in this set were discarded due to performance reasons. You can change this behaviour in the preferences (<code>rapidminer.general.md_nominal_values_limit</code>).</small>");
        }
        return buf.toString();
    }

    void attributeRenamed(AttributeMetaData amd, String oldName) {
        this.attributeMetaData.remove(oldName);
        this.attributeMetaData.put(amd.getName(), amd);
    }

    public void removeAllAttributes() {
        this.attributeMetaData.clear();
    }

    public void setNominalDataWasShrinked(boolean b) {
        this.nominalDataWasShrinked = true;
    }

    public static int getMaximumNumberOfAttributes() {
        int maxSize = 250;
        String maxSizeString = System.getProperty("rapidminer.general.md_attributes_limit");
        if (maxSizeString != null && (maxSize = Integer.parseInt(maxSizeString)) == 0) {
            maxSize = Integer.MAX_VALUE;
        }
        return maxSize;
    }
}

