/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AbstractPrecondition;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;

public class DistanceMeasurePrecondition
extends AbstractPrecondition {
    private ParameterHandler parameterHandler;

    public DistanceMeasurePrecondition(InputPort inputPort, ParameterHandler handler) {
        super(inputPort);
        this.parameterHandler = handler;
    }

    @Override
    public void check(MetaData metaData) {
        if (metaData instanceof ExampleSetMetaData) {
            ExampleSetMetaData emd = (ExampleSetMetaData)metaData;
            try {
                switch (this.parameterHandler.getParameterAsInt("measure_types")) {
                    case 1: {
                        if (this.containsOnlyType(emd, 1, false)) break;
                        this.createError(ProcessSetupError.Severity.ERROR, "measures.nominal", this.parameterHandler.getParameterAsString("nominal_measure"));
                        break;
                    }
                    case 2: {
                        if (this.containsOnlyType(emd, 2, false)) break;
                        this.createError(ProcessSetupError.Severity.ERROR, "measures.numerical", this.parameterHandler.getParameterAsString("numerical_measure"));
                        break;
                    }
                    case 3: {
                        if (this.containsOnlyType(emd, 2, false)) break;
                        this.createError(ProcessSetupError.Severity.ERROR, "measures.numerical", this.parameterHandler.getParameterAsString("divergence"));
                    }
                }
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
        }
    }

    private boolean containsOnlyType(ExampleSetMetaData emd, int type, boolean includeSpecial) {
        for (AttributeMetaData amd : emd.getAllAttributes()) {
            if (amd.isSpecial() && !includeSpecial || Ontology.ATTRIBUTE_VALUE_TYPE.isA(amd.getValueType(), type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void assumeSatisfied() {
        this.getInputPort().receiveMD(new ExampleSetMetaData());
    }

    @Override
    public String getDescription() {
        return "<em>expects:</em> ExampleSet";
    }

    @Override
    public boolean isCompatible(MetaData input, CompatibilityLevel level) {
        return ExampleSet.class.isAssignableFrom(input.getObjectClass());
    }

    @Override
    public MetaData getExpectedMetaData() {
        return new ExampleSetMetaData();
    }
}

