/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.learner.CapabilityProvider;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.quickfix.ChangeAttributeRoleQuickFix;
import com.rapidminer.operator.ports.quickfix.OperatorInsertionQuickFix;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.operator.preprocessing.discretization.AbstractDiscretizationOperator;
import com.rapidminer.operator.preprocessing.filter.MissingValueReplenishment;
import com.rapidminer.operator.preprocessing.filter.NominalToBinominal;
import com.rapidminer.operator.preprocessing.filter.NominalToNumeric;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.tools.OperatorService;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CapabilityPrecondition
extends ExampleSetPrecondition {
    protected final CapabilityProvider capabilityProvider;

    public CapabilityPrecondition(CapabilityProvider capabilityProvider, InputPort inputPort) {
        super(inputPort);
        this.capabilityProvider = capabilityProvider;
    }

    @Override
    public void makeAdditionalChecks(ExampleSetMetaData metaData) {
        if (metaData.containsAttributesWithValueType(1, false) == MetaDataInfo.YES) {
            LinkedList<QuickFix> fixes;
            if (metaData.containsAttributesWithValueType(6, false) == MetaDataInfo.YES) {
                if (!this.capabilityProvider.supportsCapability(OperatorCapability.BINOMINAL_ATTRIBUTES)) {
                    fixes = new LinkedList<QuickFix>();
                    if (this.capabilityProvider.supportsCapability(OperatorCapability.NUMERICAL_ATTRIBUTES)) {
                        fixes.add(this.createToNumericalFix(null));
                    }
                    this.createLearnerError(OperatorCapability.BINOMINAL_ATTRIBUTES.getDescription(), fixes);
                }
            } else if (!this.capabilityProvider.supportsCapability(OperatorCapability.POLYNOMINAL_ATTRIBUTES)) {
                fixes = new LinkedList();
                if (this.capabilityProvider.supportsCapability(OperatorCapability.BINOMINAL_ATTRIBUTES)) {
                    fixes.add(this.createToBinominalFix(null));
                }
                if (this.capabilityProvider.supportsCapability(OperatorCapability.NUMERICAL_ATTRIBUTES)) {
                    fixes.add(this.createToNumericalFix(null));
                }
                this.createLearnerError(OperatorCapability.POLYNOMINAL_ATTRIBUTES.getDescription(), fixes);
            }
        }
        if (metaData.containsAttributesWithValueType(2, false) == MetaDataInfo.YES && !this.capabilityProvider.supportsCapability(OperatorCapability.NUMERICAL_ATTRIBUTES)) {
            this.createLearnerError(OperatorCapability.NUMERICAL_ATTRIBUTES.getDescription(), AbstractDiscretizationOperator.createDiscretizationFixes(this.getInputPort(), null));
        }
        this.checkLabelPreconditions(metaData);
        if (!this.capabilityProvider.supportsCapability(OperatorCapability.WEIGHTED_EXAMPLES)) {
            switch (metaData.hasSpecial("weight")) {
                case YES: {
                    this.createError(ProcessSetupError.Severity.WARNING, "learner_does_not_support_weights", new Object[0]);
                    break;
                }
            }
        }
        if (!this.capabilityProvider.supportsCapability(OperatorCapability.MISSING_VALUES) && metaData.getAllAttributes() != null) {
            for (AttributeMetaData amd : metaData.getAllAttributes()) {
                if (amd.containsMissingValues() != MetaDataInfo.YES) continue;
                this.createLearnerError(OperatorCapability.MISSING_VALUES.getDescription(), Collections.singletonList(new OperatorInsertionQuickFix("insert_missing_value_replenishment", new String[0], 1, this.getInputPort()){

                    @Override
                    public Operator createOperator() throws OperatorCreationException {
                        return OperatorService.createOperator(MissingValueReplenishment.class);
                    }
                }));
                break;
            }
        }
    }

    protected void checkLabelPreconditions(ExampleSetMetaData metaData) {
        if (!this.capabilityProvider.supportsCapability(OperatorCapability.NO_LABEL) && (this.capabilityProvider.supportsCapability(OperatorCapability.ONE_CLASS_LABEL) || this.capabilityProvider.supportsCapability(OperatorCapability.BINOMINAL_LABEL) || this.capabilityProvider.supportsCapability(OperatorCapability.POLYNOMINAL_LABEL) || this.capabilityProvider.supportsCapability(OperatorCapability.NUMERICAL_LABEL))) {
            switch (metaData.hasSpecial("label")) {
                case UNKNOWN: {
                    this.getInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)this.getInputPort(), Collections.singletonList(new ChangeAttributeRoleQuickFix(this.getInputPort(), "label", "change_attribute_role", "label")), "special_unknown", "label"));
                    break;
                }
                case NO: {
                    this.getInputPort().addError(new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getInputPort(), Collections.singletonList(new ChangeAttributeRoleQuickFix(this.getInputPort(), "label", "change_attribute_role", "label")), "special_missing", "label"));
                    break;
                }
                case YES: {
                    AttributeMetaData label = metaData.getLabelMetaData();
                    LinkedList<QuickFix> fixes = new LinkedList<QuickFix>();
                    if (label.isNominal()) {
                        if (this.capabilityProvider.supportsCapability(OperatorCapability.NUMERICAL_LABEL)) {
                            fixes.addAll(this.getFixesForClassificationWhenRegressionSupported());
                        }
                        if (this.capabilityProvider.supportsCapability(OperatorCapability.ONE_CLASS_LABEL) && !this.capabilityProvider.supportsCapability(OperatorCapability.BINOMINAL_LABEL) && !this.capabilityProvider.supportsCapability(OperatorCapability.POLYNOMINAL_LABEL)) {
                            if (label.getValueSet().size() <= 1 || label.getValueSetRelation() == SetRelation.UNKNOWN) break;
                            this.createError(ProcessSetupError.Severity.ERROR, "one_class_label_invalid", label.getValueSetRelation().toString() + " " + label.getValueSet().size());
                            break;
                        }
                        if (label.getValueSet().size() == 1 && label.getValueSetRelation() == SetRelation.EQUAL) {
                            this.createError(ProcessSetupError.Severity.ERROR, "no_polynomial_label", new Object[0]);
                            break;
                        }
                        if (label.isBinominal()) {
                            if (this.capabilityProvider.supportsCapability(OperatorCapability.BINOMINAL_LABEL)) break;
                            this.createLearnerError(OperatorCapability.BINOMINAL_LABEL.getDescription(), fixes);
                            break;
                        }
                        if (this.capabilityProvider.supportsCapability(OperatorCapability.POLYNOMINAL_LABEL)) break;
                        if (this.capabilityProvider.supportsCapability(OperatorCapability.BINOMINAL_LABEL)) {
                            fixes.addAll(this.getFixesForPolynomialClassificationWhenBinominalSupported());
                            if (label.getValueSetRelation() == SetRelation.EQUAL && label.getValueSet().size() == 2) {
                                fixes.add(this.createToBinominalFix(label.getName()));
                            }
                        }
                        if (this.capabilityProvider.supportsCapability(OperatorCapability.NUMERICAL_LABEL)) {
                            fixes.add(this.createToNumericalFix(label.getName()));
                        }
                        this.createLearnerError(OperatorCapability.POLYNOMINAL_LABEL.getDescription(), fixes);
                        break;
                    }
                    if (!label.isNumerical() || this.capabilityProvider.supportsCapability(OperatorCapability.NUMERICAL_LABEL)) break;
                    this.createLearnerError(OperatorCapability.NUMERICAL_LABEL.getDescription(), AbstractDiscretizationOperator.createDiscretizationFixes(this.getInputPort(), label.getName()));
                }
            }
        }
    }

    protected Collection<QuickFix> getFixesForClassificationWhenRegressionSupported() {
        return Collections.emptyList();
    }

    protected Collection<QuickFix> getFixesForPolynomialClassificationWhenBinominalSupported() {
        return Collections.emptyList();
    }

    protected QuickFix createToBinominalFix(final String labelName) {
        return new OperatorInsertionQuickFix("insert_nominal_to_binominal_" + (labelName != null ? "label" : "attributes"), new Object[0], 10, this.getInputPort()){

            @Override
            public Operator createOperator() throws OperatorCreationException {
                NominalToBinominal op = OperatorService.createOperator(NominalToBinominal.class);
                if (labelName != null) {
                    op.setParameter("attribute_filter_type", AttributeSubsetSelector.CONDITION_NAMES[1]);
                    op.setParameter("include_special_attributes", "true");
                    op.setParameter("attribute", labelName);
                }
                return op;
            }
        };
    }

    protected QuickFix createToNumericalFix(final String labelName) {
        return new OperatorInsertionQuickFix("insert_nominal_to_numerical_" + (labelName != null ? "label" : "attributes"), new Object[0], 10, this.getInputPort()){

            @Override
            public Operator createOperator() throws OperatorCreationException {
                NominalToNumeric op = OperatorService.createOperator(NominalToNumeric.class);
                if (labelName != null) {
                    op.setParameter("attribute_filter_type", AttributeSubsetSelector.CONDITION_NAMES[3]);
                    op.setParameter("include_special_attributes", "true");
                    op.setParameter("regular_expression", labelName);
                }
                return op;
            }
        };
    }

    protected void createLearnerError(String description, List<? extends QuickFix> list) {
        String id = "Learner";
        if (this.capabilityProvider instanceof Operator) {
            id = ((Operator)((Object)this.capabilityProvider)).getOperatorDescription().getName();
        }
        this.createError(ProcessSetupError.Severity.ERROR, list, "learner_cannot_handle", id, description);
    }
}

