/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.UndefinedParameterError;

public class AttributeSubsetPassThroughRule
extends ExampleSetPassThroughRule {
    private final Operator operator;
    private final boolean keepSpecialIfNotIncluded;
    private final AttributeSubsetSelector selector;

    public AttributeSubsetPassThroughRule(InputPort inputPort, OutputPort outputPort, Operator operator, boolean keepSpecialIfNotIncluded) {
        super(inputPort, outputPort, SetRelation.EQUAL);
        this.operator = operator;
        this.keepSpecialIfNotIncluded = keepSpecialIfNotIncluded;
        this.selector = new AttributeSubsetSelector(operator, inputPort);
    }

    @Override
    public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) {
        try {
            AttributeSubsetSelector.createCondition(this.operator.getParameterAsString("attribute_filter_type"), this.operator);
        }
        catch (UndefinedParameterError e) {
        }
        catch (ConditionCreationException e) {
            try {
                this.operator.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.operator.getPortOwner(), "attribute_filter_condition_error", this.operator.getParameterAsString("attribute_filter_type")));
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
        }
        ExampleSetMetaData result = this.selector.getMetaDataSubset(metaData, this.keepSpecialIfNotIncluded);
        return result;
    }
}

