/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AbstractPrecondition;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.quickfix.AttributeSelectionQuickFix;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AttributeSetPrecondition
extends AbstractPrecondition {
    private final String[] requiredAttributes;
    private final AttributeNameProvider requiredNameProvider;
    private final int requiredAttributesType;

    public AttributeSetPrecondition(InputPort inputPort, String ... requiredAttributeNames) {
        this(inputPort, (AttributeNameProvider)null, requiredAttributeNames);
    }

    public AttributeSetPrecondition(InputPort inputPort, AttributeNameProvider attributeNameProvider, String ... requiredAttributeNames) {
        this(inputPort, attributeNameProvider, 0, requiredAttributeNames);
    }

    public AttributeSetPrecondition(InputPort inputPort, AttributeNameProvider attributeNameProvider, int typeOfRequiredAttributes, String ... requiredAttributeNames) {
        super(inputPort);
        this.requiredAttributes = requiredAttributeNames;
        this.requiredNameProvider = attributeNameProvider;
        this.requiredAttributesType = typeOfRequiredAttributes;
    }

    @Override
    public void assumeSatisfied() {
        this.getInputPort().receiveMD(new ExampleSetMetaData());
    }

    @Override
    public void check(MetaData metaData) {
        if (metaData != null && metaData instanceof ExampleSetMetaData) {
            ExampleSetMetaData emd = (ExampleSetMetaData)metaData;
            this.checkAttributeNames(this.requiredAttributes, emd);
            if (this.requiredNameProvider != null) {
                this.checkAttributeNames(this.requiredNameProvider.getRequiredAttributeNames(), emd);
            }
            this.makeAdditionalChecks(emd);
        }
    }

    private void checkAttributeNames(String[] requiredNames, ExampleSetMetaData emd) {
        for (String attributeName : requiredNames) {
            AttributeMetaData amd;
            if (attributeName.contains("%{") || attributeName == null || attributeName.length() <= 0) continue;
            MetaDataInfo attInfo = emd.containsAttributeName(attributeName);
            if (attInfo == MetaDataInfo.NO) {
                QuickFix fix = null;
                try {
                    fix = this.getQuickFix(emd);
                }
                catch (UndefinedParameterError e) {
                    // empty catch block
                }
                ProcessSetupError.Severity sev = ProcessSetupError.Severity.WARNING;
                if (emd.getAttributeSetRelation() == SetRelation.EQUAL) {
                    sev = ProcessSetupError.Severity.ERROR;
                }
                if (fix != null) {
                    this.createError(sev, Collections.singletonList(fix), "missing_attribute", attributeName);
                    continue;
                }
                this.createError(sev, "missing_attribute", attributeName);
                continue;
            }
            if (attInfo != MetaDataInfo.YES || Ontology.ATTRIBUTE_VALUE_TYPE.isA((amd = emd.getAttributeByName(attributeName)).getValueType(), this.requiredAttributesType)) continue;
            QuickFix fix = null;
            try {
                fix = this.getQuickFix(emd);
            }
            catch (UndefinedParameterError e) {
                // empty catch block
            }
            if (fix != null) {
                this.createError(ProcessSetupError.Severity.ERROR, Collections.singletonList(fix), "attribute_has_wrong_type", amd.getName(), Ontology.VALUE_TYPE_NAMES[this.requiredAttributesType]);
                continue;
            }
            this.createError(ProcessSetupError.Severity.ERROR, "attribute_has_wrong_type", amd.getName(), Ontology.VALUE_TYPE_NAMES[this.requiredAttributesType]);
        }
    }

    protected final String[] getRequiredNames() {
        int i;
        int length = this.requiredAttributes.length;
        String[] providedNames = this.requiredNameProvider.getRequiredAttributeNames();
        if (this.requiredNameProvider != null) {
            length += providedNames.length;
        }
        String[] result = new String[length];
        for (i = 0; i < this.requiredAttributes.length; ++i) {
            result[i] = this.requiredAttributes[i];
        }
        for (i = 0; i < providedNames.length; ++i) {
            result[i + this.requiredAttributes.length] = providedNames[i];
        }
        return result;
    }

    public QuickFix getQuickFix(ExampleSetMetaData emd) throws UndefinedParameterError {
        ParameterAttributeNameProvider provider;
        if (this.requiredNameProvider != null && this.requiredNameProvider instanceof ParameterAttributeNameProvider && (provider = (ParameterAttributeNameProvider)this.requiredNameProvider).getParameterKeys().length == 1 && provider.getRequiredAttributeNames().length == 1) {
            return new AttributeSelectionQuickFix(emd, provider.getParameterKeys()[0], provider.getHandler(), provider.getRequiredAttributeNames()[0], this.requiredAttributesType);
        }
        return null;
    }

    public void makeAdditionalChecks(ExampleSetMetaData emd) {
    }

    @Override
    public String getDescription() {
        return "<em>expects:</em> ExampleSet";
    }

    @Override
    public boolean isCompatible(MetaData input, CompatibilityLevel level) {
        return ExampleSet.class.isAssignableFrom(input.getObjectClass());
    }

    @Override
    public MetaData getExpectedMetaData() {
        return new ExampleSetMetaData();
    }

    public static AttributeNameProvider getAttributesByParameter(ParameterHandler handler, String ... parameterKeys) {
        return new ParameterAttributeNameProvider(handler, parameterKeys);
    }

    public static AttributeNameProvider getAttributesByParameterListEntry(ParameterHandler handler, String parameterListKey, int entry) {
        return new ParameterListAttributeNameProvider(handler, parameterListKey, entry);
    }

    private static class ParameterListAttributeNameProvider
    extends AttributeNameProvider {
        private final ParameterHandler handler;
        private final String parameterKey;
        private final int entry;

        public ParameterListAttributeNameProvider(ParameterHandler handler, String parameterKey, int entry) {
            this.handler = handler;
            this.parameterKey = parameterKey;
            this.entry = entry;
        }

        @Override
        public String[] getRequiredAttributeNames() {
            try {
                if (this.handler.isParameterSet(this.parameterKey)) {
                    List<String[]> parameterList = this.handler.getParameterList(this.parameterKey);
                    String[] attributeNames = new String[parameterList.size()];
                    int i = 0;
                    for (String[] pair : parameterList) {
                        attributeNames[i] = pair[this.entry];
                        ++i;
                    }
                    return attributeNames;
                }
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
            return new String[0];
        }

        public ParameterHandler getHandler() {
            return this.handler;
        }

        public String getParameterKey() {
            return this.parameterKey;
        }
    }

    private static class ParameterAttributeNameProvider
    extends AttributeNameProvider {
        private final ParameterHandler handler;
        private final String[] parameterKeys;

        public ParameterAttributeNameProvider(ParameterHandler handler, String ... parameterKeys) {
            this.handler = handler;
            this.parameterKeys = parameterKeys;
        }

        @Override
        public String[] getRequiredAttributeNames() {
            ArrayList<String> names = new ArrayList<String>();
            for (String key : this.parameterKeys) {
                try {
                    names.add(this.handler.getParameterAsString(key));
                }
                catch (UndefinedParameterError e) {
                    // empty catch block
                }
            }
            return names.toArray(new String[names.size()]);
        }

        public ParameterHandler getHandler() {
            return this.handler;
        }

        public String[] getParameterKeys() {
            return this.parameterKeys;
        }
    }

    public static abstract class AttributeNameProvider {
        public abstract String[] getRequiredAttributeNames();
    }
}

