/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AbstractPrecondition;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;

public class AttributeParameterPrecondition
extends AbstractPrecondition {
    private final Operator operator;
    private final String parameterName;
    private final int attributeType;
    private final String attributeRole;

    public AttributeParameterPrecondition(InputPort inport, Operator operator, String parameterName) {
        this(inport, operator, parameterName, null, 0);
    }

    public AttributeParameterPrecondition(InputPort inport, Operator operator, String parameterName, int attributeType) {
        this(inport, operator, parameterName, null, attributeType);
    }

    public AttributeParameterPrecondition(InputPort inport, Operator operator, String parameterName, String attributeRole, int attributeType) {
        super(inport);
        this.operator = operator;
        this.parameterName = parameterName;
        this.attributeType = attributeType;
        this.attributeRole = attributeRole;
    }

    @Override
    public void check(MetaData metaData) {
        if (metaData != null && metaData instanceof ExampleSetMetaData) {
            ExampleSetMetaData emd = (ExampleSetMetaData)metaData;
            String attributeName = this.getName();
            if (attributeName != null) {
                MetaDataInfo containsRelation = emd.containsAttributeName(attributeName);
                if (containsRelation == MetaDataInfo.YES) {
                    AttributeMetaData amd = emd.getAttributeByName(attributeName);
                    if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(amd.getValueType(), this.attributeType)) {
                        if (this.attributeRole != null && !this.attributeRole.equals(amd.getRole())) {
                            this.createError(ProcessSetupError.Severity.ERROR, "attribute_must_have_role", attributeName, this.attributeRole);
                        }
                    } else {
                        this.createError(ProcessSetupError.Severity.ERROR, "attribute_has_wrong_type", attributeName, Ontology.ATTRIBUTE_VALUE_TYPE.getNames()[this.attributeType]);
                    }
                } else if (containsRelation == MetaDataInfo.UNKNOWN) {
                    this.createError(ProcessSetupError.Severity.WARNING, "missing_attribute", attributeName);
                } else {
                    this.createError(ProcessSetupError.Severity.ERROR, "missing_attribute", attributeName);
                }
            }
            this.makeAdditionalChecks(emd);
        }
    }

    protected String getName() {
        try {
            return this.operator.getParameterAsString(this.parameterName);
        }
        catch (UndefinedParameterError e) {
            return null;
        }
    }

    @Override
    public void assumeSatisfied() {
        this.getInputPort().receiveMD(new ExampleSetMetaData());
    }

    public QuickFix getQuickFix(ExampleSetMetaData emd) throws UndefinedParameterError {
        return null;
    }

    public void makeAdditionalChecks(ExampleSetMetaData emd) {
    }

    @Override
    public String getDescription() {
        return "<em>expects:</em> ExampleSet";
    }

    @Override
    public boolean isCompatible(MetaData input, CompatibilityLevel level) {
        return ExampleSet.class.isAssignableFrom(input.getObjectClass());
    }

    @Override
    public MetaData getExpectedMetaData() {
        return new ExampleSetMetaData();
    }
}

