/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.metadata;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MDReal;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.container.Range;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class AttributeMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ExampleSetMetaData owner = null;
    private String name;
    private int type = 0;
    private String role = null;
    private MDInteger numberOfMissingValues = new MDInteger(0);
    private SetRelation valueSetRelation = SetRelation.UNKNOWN;
    private Range valueRange = new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private Set<String> valueSet = new TreeSet<String>();
    private String mode;
    private MDReal mean = new MDReal();
    private Annotations annotations = new Annotations();

    public AttributeMetaData(String name, int type) {
        this(name, type, null);
    }

    public AttributeMetaData(AttributeRole role, ExampleSet exampleSet) {
        this(role, exampleSet, false);
    }

    public AttributeMetaData(AttributeRole role, ExampleSet exampleSet, boolean shortened) {
        this(role.getAttribute().getName(), role.getAttribute().getValueType(), role.getSpecialName());
        Attribute att = role.getAttribute();
        if (att.isNominal()) {
            int maxValues = shortened ? AttributeMetaData.getMaximumNumberOfNominalValues() : Integer.MAX_VALUE;
            this.valueSet.clear();
            for (String value : att.getMapping().getValues()) {
                if (shortened && value.length() > 100) {
                    value = value.substring(0, 100);
                }
                this.valueSet.add(value);
                if (--maxValues != 0) continue;
                break;
            }
            this.valueSetRelation = SetRelation.EQUAL;
        }
        if (exampleSet != null) {
            double modeIndex;
            this.numberOfMissingValues = new MDInteger((int)exampleSet.getStatistics(att, "unknown"));
            if (att.isNumerical() || Ontology.ATTRIBUTE_VALUE_TYPE.isA(att.getValueType(), 9)) {
                this.valueSetRelation = SetRelation.EQUAL;
                this.valueRange = new Range(exampleSet.getStatistics(att, "minimum"), exampleSet.getStatistics(att, "maximum"));
                this.setMean(new MDReal(exampleSet.getStatistics(att, "average")));
            }
            if (att.isNominal() && !Double.isNaN(modeIndex = exampleSet.getStatistics(att, "mode")) && modeIndex >= 0.0 && modeIndex < (double)att.getMapping().size()) {
                this.setMode(att.getMapping().mapIndex((int)modeIndex));
            }
        } else {
            this.numberOfMissingValues = new MDInteger();
            if (att.isNumerical()) {
                this.setMean(new MDReal());
            }
            if (att.isNominal()) {
                this.setMode(null);
            }
        }
        this.annotations.putAll(att.getAnnotations());
    }

    public AttributeMetaData(String name, int type, String role) {
        this.name = name;
        this.type = type;
        this.role = role;
    }

    public AttributeMetaData(String name, String role, int nominalType, String ... values) {
        this(name, role, values);
        this.type = nominalType;
    }

    public AttributeMetaData(String name, String role, String ... values) {
        this.name = name;
        this.type = 1;
        this.role = role;
        this.valueSetRelation = SetRelation.EQUAL;
        for (String string : values) {
            this.valueSet.add(string);
        }
    }

    public AttributeMetaData(String name, String role, Range range) {
        this.name = name;
        this.role = role;
        this.type = 4;
        this.valueRange = range;
        this.valueSetRelation = SetRelation.EQUAL;
    }

    public AttributeMetaData(String name, String role, int type, Range range) {
        this(name, role, range);
        this.type = type;
    }

    private AttributeMetaData(AttributeMetaData attributeMetaData) {
        this.name = attributeMetaData.name;
        this.role = attributeMetaData.role;
        this.type = attributeMetaData.type;
        this.numberOfMissingValues = new MDInteger(attributeMetaData.numberOfMissingValues);
        this.mean = new MDReal(attributeMetaData.mean);
        this.mode = attributeMetaData.mode;
        this.valueSetRelation = attributeMetaData.getValueSetRelation();
        this.valueRange = new Range(attributeMetaData.getValueRange());
        this.valueSet = new TreeSet<String>();
        this.annotations = new Annotations(attributeMetaData.annotations);
        this.valueSet.addAll(attributeMetaData.getValueSet());
    }

    public AttributeMetaData(Attribute attribute) {
        this.name = attribute.getName();
        this.type = attribute.getValueType();
        this.annotations.putAll(attribute.getAnnotations());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
    }

    public String getRole() {
        return this.role;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        if (this.owner != null) {
            this.owner.attributeRenamed(this, oldName);
        }
    }

    public String getTypeName() {
        return Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(this.type);
    }

    public int getValueType() {
        return this.type;
    }

    public void setType(int type) {
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(type, 2)) {
            this.valueSet.clear();
        } else {
            this.setValueRange(new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), SetRelation.SUBSET);
        }
        this.type = type;
    }

    public String toString() {
        return this.getDescription();
    }

    public String getDescription() {
        StringBuilder buf = new StringBuilder();
        if (this.role != null && !this.role.equals("attribute")) {
            buf.append("<em>");
            buf.append(this.role);
            buf.append("</em>: ");
        }
        buf.append(this.getName());
        buf.append(" (");
        buf.append(this.getValueTypeName());
        if (this.valueSetRelation != SetRelation.UNKNOWN) {
            buf.append(" in ");
            this.appendValueSetDescription(buf);
        } else if (this.isNominal()) {
            buf.append(", values unkown");
        } else {
            buf.append(", range unknown");
        }
        switch (this.containsMissingValues()) {
            case NO: {
                buf.append("; no missing values");
                break;
            }
            case YES: {
                buf.append("; ");
                buf.append(this.numberOfMissingValues.toString());
                buf.append(" missing values");
                break;
            }
            case UNKNOWN: {
                buf.append("; may contain missing values");
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public String getValueTypeName() {
        return Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(this.getValueType());
    }

    public String getValueSetDescription() {
        StringBuilder buf = new StringBuilder();
        this.appendValueSetDescription(buf);
        return buf.toString();
    }

    private void appendValueSetDescription(StringBuilder buf) {
        if (this.isNominal()) {
            buf.append((Object)((Object)this.valueSetRelation) + " {");
            boolean first = true;
            String mode = this.getMode();
            int index = 0;
            for (String value : this.valueSet) {
                ++index;
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                if (index >= 10) {
                    buf.append("...");
                    break;
                }
                boolean isMode = value.equals(mode);
                if (isMode) {
                    buf.append("<span style=\"text-decoration:underline\">");
                }
                buf.append(value);
                if (!isMode) continue;
                buf.append("</span>");
            }
            buf.append("}");
        }
        if (this.isNumerical()) {
            buf.append((Object)((Object)this.valueSetRelation) + " [");
            if (this.getValueRange() != null) {
                buf.append(Tools.formatNumber(this.getValueRange().getLower(), 3));
                buf.append("...");
                buf.append(Tools.formatNumber(this.getValueRange().getUpper(), 3));
                buf.append("]");
            }
            if (this.getMean().isKnown()) {
                buf.append("; mean ");
                buf.append(this.getMean().toString());
            }
        }
        if (this.valueRange != null && Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.getValueType(), 9) && !Double.isInfinite(this.getValueRange().getLower()) && !Double.isInfinite(this.getValueRange().getUpper())) {
            buf.append((Object)((Object)this.valueSetRelation) + " [");
            switch (this.getValueType()) {
                case 10: {
                    buf.append(Tools.formatDate(new Date((long)this.getValueRange().getLower())));
                    buf.append("...");
                    buf.append(Tools.formatDate(new Date((long)this.getValueRange().getUpper())));
                    buf.append("]");
                    break;
                }
                case 11: {
                    buf.append(Tools.formatTime(new Date((long)this.getValueRange().getLower())));
                    buf.append("...");
                    buf.append(Tools.formatTime(new Date((long)this.getValueRange().getUpper())));
                    buf.append("]");
                    break;
                }
                case 9: {
                    buf.append(Tools.formatDateTime(new Date((long)this.getValueRange().getLower())));
                    buf.append("...");
                    buf.append(Tools.formatDateTime(new Date((long)this.getValueRange().getUpper())));
                    buf.append("]");
                }
            }
        }
    }

    protected String getDescriptionAsTableRow() {
        StringBuilder b = new StringBuilder();
        b.append("<tr><td>");
        String role2 = this.getRole();
        if (role2 == null) {
            role2 = "-";
        }
        b.append(role2).append("</td><td>");
        b.append(this.getName());
        String unit = this.getAnnotations().getAnnotation("Unit");
        if (unit != null) {
            b.append(" <em>[").append(unit).append("]</em>");
        }
        b.append("</td><td>");
        b.append(this.getValueTypeName()).append("</td><td>");
        if (this.valueSetRelation != SetRelation.UNKNOWN) {
            this.appendValueSetDescription(b);
        } else if (this.isNominal()) {
            b.append("values unkown");
        } else {
            b.append("range unknown");
        }
        b.append("</td><td>");
        switch (this.containsMissingValues()) {
            case NO: {
                b.append("no missing values");
                break;
            }
            case YES: {
                b.append(this.numberOfMissingValues.toString());
                b.append(" missing values");
                break;
            }
            case UNKNOWN: {
                b.append("may contain missing values");
            }
        }
        String comment = this.getAnnotations().getAnnotation("Comment");
        b.append("</td><td>").append(comment != null ? comment : "-").append("</tr></tr>");
        return b.toString();
    }

    public AttributeMetaData clone() {
        return new AttributeMetaData(this);
    }

    public boolean isNominal() {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.type, 1);
    }

    public boolean isBinominal() {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.type, 6);
    }

    public boolean isPolynominal() {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.type, 7);
    }

    public boolean isNumerical() {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.type, 2);
    }

    public MetaDataInfo containsMissingValues() {
        return this.numberOfMissingValues.isAtLeast(1);
    }

    public void setNumberOfMissingValues(MDInteger numberOfMissingValues) {
        this.numberOfMissingValues = numberOfMissingValues;
    }

    public MDInteger getNumberOfMissingValues() {
        return this.numberOfMissingValues;
    }

    public SetRelation getValueSetRelation() {
        return this.valueSetRelation;
    }

    public Set<String> getValueSet() {
        return this.valueSet;
    }

    public void setValueSet(Set<String> valueSet, SetRelation relation) {
        this.valueSetRelation = relation;
        this.valueSet = valueSet;
    }

    public Range getValueRange() {
        return this.valueRange;
    }

    public void setValueRange(Range range, SetRelation relation) {
        this.valueSetRelation = relation;
        this.valueRange = range;
    }

    public AttributeMetaData copy() {
        return new AttributeMetaData(this);
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setRegular() {
        this.role = null;
    }

    public boolean isSpecial() {
        return this.role != null;
    }

    public static AttributeMetaData createPredictionMetaData(AttributeMetaData labelMetaData) {
        AttributeMetaData result = labelMetaData.clone();
        result.setName("prediction(" + result.getName() + ")");
        result.setRole("prediction");
        return result;
    }

    public static ExampleSetMetaData createConfidenceAttributeMetaData(ExampleSetMetaData exampleSetMD) {
        AttributeMetaData labelMetaData;
        if (exampleSetMD.hasSpecial("label") == MetaDataInfo.YES && (labelMetaData = exampleSetMD.getLabelMetaData()).isNominal()) {
            for (String value : labelMetaData.getValueSet()) {
                AttributeMetaData conf = new AttributeMetaData("confidence_" + value, 4, "confidence");
                conf.setValueRange(new Range(0.0, 1.0), SetRelation.EQUAL);
                exampleSetMD.addAttribute(conf);
            }
            exampleSetMD.mergeSetRelation(labelMetaData.getValueSetRelation());
            return exampleSetMD;
        }
        return exampleSetMD;
    }

    public void setValueSetRelation(SetRelation valueSetRelation) {
        this.valueSetRelation = valueSetRelation;
    }

    public void setMean(MDReal mean) {
        this.mean = mean;
    }

    public MDReal getMean() {
        return this.mean;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public void merge(AttributeMetaData amd) {
        if (amd.isNominal() != this.isNominal()) {
            this.type = 0;
        }
        if (this.isNominal()) {
            if (amd.valueSet != null && this.valueSet != null) {
                if (!((Object)amd.valueSet).equals(this.valueSet)) {
                    this.valueSetRelation.merge(SetRelation.SUBSET);
                }
                this.valueSet.addAll(amd.valueSet);
            }
            this.valueSetRelation.merge(amd.valueSetRelation);
        }
        if (this.isNumerical()) {
            if (this.valueRange != null && amd.valueRange != null) {
                double min = Math.min(amd.valueRange.getLower(), this.valueRange.getLower());
                double max = Math.max(amd.valueRange.getUpper(), this.valueRange.getUpper());
                this.valueRange = new Range(min, max);
            }
            this.valueSetRelation.merge(amd.valueSetRelation);
        }
    }

    public String getRangeString() {
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.getValueType(), 9)) {
            if (!Double.isInfinite(this.getValueRange().getLower()) && !Double.isInfinite(this.getValueRange().getUpper())) {
                StringBuilder buf = new StringBuilder();
                buf.append(this.valueSetRelation.toString());
                if (this.valueSetRelation != SetRelation.UNKNOWN) {
                    buf.append("[");
                    switch (this.getValueType()) {
                        case 10: {
                            buf.append(Tools.formatDate(new Date((long)this.getValueRange().getLower())));
                            buf.append(" \u2013 ");
                            buf.append(Tools.formatDate(new Date((long)this.getValueRange().getUpper())));
                            break;
                        }
                        case 11: {
                            buf.append(Tools.formatTime(new Date((long)this.getValueRange().getLower())));
                            buf.append(" \u2013 ");
                            buf.append(Tools.formatTime(new Date((long)this.getValueRange().getUpper())));
                            break;
                        }
                        case 9: {
                            buf.append(Tools.formatDateTime(new Date((long)this.getValueRange().getLower())));
                            buf.append(" \u2013 ");
                            buf.append(Tools.formatDateTime(new Date((long)this.getValueRange().getUpper())));
                        }
                    }
                    buf.append("]");
                    return buf.toString();
                }
                return "Unknown date range";
            }
            return "Unbounded date range";
        }
        if (!this.isNominal() && this.valueRange != null) {
            return this.valueSetRelation.toString() + (this.valueSetRelation != SetRelation.UNKNOWN ? this.valueRange.toString() : "");
        }
        if (this.isNominal() && this.valueSet != null) {
            return this.valueSetRelation.toString() + (this.valueSetRelation != SetRelation.UNKNOWN ? this.valueSet.toString() : "");
        }
        return "unknown";
    }

    public void shrinkValueSet() {
        int maxSize = AttributeMetaData.getMaximumNumberOfNominalValues();
        this.shrinkValueSet(maxSize);
    }

    public static int getMaximumNumberOfNominalValues() {
        int maxSize = 100;
        String maxSizeString = System.getProperty("rapidminer.general.md_nominal_values_limit");
        if (maxSizeString != null && (maxSize = Integer.parseInt(maxSizeString)) == 0) {
            maxSize = Integer.MAX_VALUE;
        }
        return maxSize;
    }

    private void shrinkValueSet(int maxSize) {
        if (this.valueSet != null && this.valueSet.size() > maxSize) {
            TreeSet<String> newSet = new TreeSet<String>();
            Iterator<String> i = this.valueSet.iterator();
            for (int count = 0; i.hasNext() && count < maxSize; ++count) {
                newSet.add(i.next());
            }
            this.valueSet = newSet;
            this.valueSetRelation = this.valueSetRelation.merge(SetRelation.SUPERSET);
            if (this.owner != null) {
                this.owner.setNominalDataWasShrinked(true);
            }
        }
    }

    AttributeMetaData registerOwner(ExampleSetMetaData owner) {
        if (this.owner == null) {
            this.owner = owner;
            return this;
        }
        AttributeMetaData clone = this.clone();
        clone.owner = owner;
        return clone;
    }

    public void setAnnotations(Annotations annotations) {
        this.annotations = annotations == null ? new Annotations() : annotations;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }
}

