/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.impl;

import com.rapidminer.Process;
import com.rapidminer.operator.DebugMode;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortException;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.impl.AbstractPort;
import com.rapidminer.operator.ports.impl.CannotConnectPortException;
import com.rapidminer.operator.ports.impl.InputPortImpl;
import com.rapidminer.operator.ports.metadata.MetaData;

public class OutputPortImpl
extends AbstractPort
implements OutputPort {
    private InputPort connectedTo;
    private MetaData metaData;
    private MetaData realMetaData;

    protected OutputPortImpl(Ports<? extends Port> owner, String name, boolean simulatesStack) {
        super(owner, name, simulatesStack);
    }

    @Override
    public void clear(int clearFlags) {
        super.clear(clearFlags);
        if ((clearFlags & 0x10) > 0) {
            this.realMetaData = null;
        }
        if ((clearFlags & 2) > 0) {
            this.metaData = null;
        }
    }

    private void assertConnected() throws PortException {
        if (this.connectedTo == null) {
            throw new PortException(this, "Not connected.");
        }
    }

    @Override
    public void connectTo(InputPort inputPort) throws PortException {
        boolean connected;
        if (this.connectedTo == inputPort) {
            return;
        }
        if (inputPort.getPorts().getOwner().getConnectionContext() != this.getPorts().getOwner().getConnectionContext()) {
            throw new PortException("Cannot connect " + this.getSpec() + " to " + inputPort.getSpec() + ": ports must be in the same subprocess, but are in " + this.getPorts().getOwner().getConnectionContext().getName() + " and " + inputPort.getPorts().getOwner().getConnectionContext().getName() + ".");
        }
        boolean destConnected = inputPort.isConnected();
        boolean sourceConnected = this.isConnected();
        boolean bothConnected = destConnected && sourceConnected;
        boolean bl = connected = destConnected || sourceConnected;
        if (connected) {
            if (bothConnected) {
                throw new CannotConnectPortException(this, inputPort, this.getDestination(), inputPort.getSource());
            }
            if (sourceConnected) {
                throw new CannotConnectPortException((OutputPort)this, inputPort, this.getDestination());
            }
            throw new CannotConnectPortException((OutputPort)this, inputPort, inputPort.getSource());
        }
        this.connectedTo = inputPort;
        ((InputPortImpl)inputPort).connect(this);
        this.fireUpdate(this);
    }

    @Override
    public void disconnect() throws PortException {
        this.assertConnected();
        ((InputPortImpl)this.connectedTo).connect(null);
        this.connectedTo.receive(null);
        this.connectedTo.receiveMD(null);
        this.connectedTo = null;
        this.fireUpdate(this);
    }

    @Override
    public void deliver(IOObject object) {
        Process process;
        if (object != null) {
            object.appendOperatorToHistory(this.getPorts().getOwner().getOperator(), this);
        }
        this.setData(object);
        if (this.connectedTo != null) {
            this.connectedTo.receive(object);
        }
        this.realMetaData = (process = this.getPorts().getOwner().getOperator().getProcess()) != null && process.getDebugMode() == DebugMode.COLLECT_METADATA_AFTER_EXECUTION ? (object == null ? null : MetaData.forIOObject(object)) : null;
    }

    @Override
    public void deliverMD(MetaData md) {
        this.metaData = md;
        if (this.connectedTo != null) {
            this.connectedTo.receiveMD(md);
        }
    }

    @Override
    public MetaData getMetaData() {
        if (this.realMetaData != null) {
            return this.realMetaData;
        }
        return this.metaData;
    }

    @Override
    public InputPort getDestination() {
        return this.connectedTo;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public boolean isConnected() {
        return this.connectedTo != null;
    }

    @Override
    public boolean shouldAutoConnect() {
        return this.getPorts().getOwner().getOperator().shouldAutoConnect(this);
    }
}

