/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.impl;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortOwner;
import com.rapidminer.operator.ports.impl.AbstractPorts;
import com.rapidminer.operator.ports.impl.InputPortImpl;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import java.util.List;

public class InputPortsImpl
extends AbstractPorts<InputPort>
implements InputPorts {
    public InputPortsImpl(PortOwner owner) {
        super(owner);
    }

    @Override
    public void checkPreconditions() {
        for (InputPort port : this.getAllPorts()) {
            port.checkPreconditions();
        }
    }

    @Override
    public InputPort createPort(String name) {
        return this.createPort(name, true);
    }

    @Override
    public InputPort createPort(String name, boolean add) {
        InputPortImpl in = new InputPortImpl(this, name, true);
        if (add) {
            this.addPort(in);
        }
        return in;
    }

    @Override
    public InputPort createPassThroughPort(String name) {
        InputPortImpl in = new InputPortImpl(this, name, false);
        this.addPort(in);
        return in;
    }

    @Override
    public InputPort createPort(String name, Class<? extends IOObject> clazz) {
        return this.createPort(name, new MetaData(clazz));
    }

    @Override
    public InputPort createPort(String name, MetaData metaData) {
        InputPort in = this.createPort(name);
        in.addPrecondition(new SimplePrecondition(in, metaData));
        return in;
    }

    @Override
    public void disconnectAll() {
        this.disconnectAllBut(null);
    }

    @Override
    public void disconnectAllBut(List<Operator> exceptions) {
        boolean success;
        block0: do {
            success = false;
            for (InputPort port : this.getAllPorts()) {
                Operator sourceOp;
                if (!port.isConnected()) continue;
                OutputPort source = port.getSource();
                boolean isException = false;
                if (exceptions != null && exceptions.contains(sourceOp = source.getPorts().getOwner().getOperator())) {
                    isException = true;
                }
                if (isException) continue;
                source.disconnect();
                success = true;
                continue block0;
            }
        } while (success);
    }
}

