/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.impl;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.MetaDataChangeListener;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.impl.AbstractPort;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;

public class InputPortImpl
extends AbstractPort
implements InputPort {
    private final Collection<MetaDataChangeListener> metaDataChangeListeners = new LinkedList<MetaDataChangeListener>();
    private final Collection<Precondition> preconditions = new LinkedList<Precondition>();
    private MetaData metaData;
    private OutputPort sourceOutputPort;

    protected InputPortImpl(Ports<? extends Port> owner, String name, boolean simulatesStack) {
        super(owner, name, simulatesStack);
    }

    @Override
    public void clear(int clearFlags) {
        super.clear(clearFlags);
        if ((clearFlags & 2) > 0) {
            this.metaData = null;
            this.informListenersOfChange(null);
        }
    }

    @Override
    public void receive(IOObject object) {
        this.setData(object);
    }

    @Override
    public void receiveMD(MetaData metaData) {
        assert (this.metaData != null);
        this.metaData = metaData;
        this.informListenersOfChange(metaData);
    }

    @Override
    public MetaData getMetaData() {
        return this.metaData;
    }

    void connect(OutputPort outputPort) {
        this.sourceOutputPort = outputPort;
        this.fireUpdate(this);
    }

    @Override
    public OutputPort getSource() {
        return this.sourceOutputPort;
    }

    @Override
    public void addPrecondition(Precondition precondition) {
        this.preconditions.add(precondition);
    }

    @Override
    public void checkPreconditions() {
        MetaData metaData = this.getMetaData();
        for (Precondition precondition : this.preconditions) {
            try {
                precondition.check(metaData);
            }
            catch (Exception e) {
                this.getPorts().getOwner().getOperator().getLogger().log(Level.WARNING, "Error checking preconditions at " + this.getSpec() + ": " + e, e);
                this.addError(new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)this, "exception_checking_precondition", e.toString()));
            }
        }
    }

    @Override
    public String getPreconditionDescription() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getName());
        buf.append(": ");
        for (Precondition precondition : this.preconditions) {
            buf.append(precondition.getDescription());
        }
        return buf.toString();
    }

    @Override
    public boolean isInputCompatible(MetaData input, CompatibilityLevel level) {
        for (Precondition precondition : this.preconditions) {
            if (precondition.isCompatible(input, level)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDescription() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Precondition precondition : this.preconditions) {
            if (!first) {
                b.append(", ");
            } else {
                first = false;
            }
            b.append(precondition.getDescription());
        }
        return b.toString();
    }

    @Override
    public boolean isConnected() {
        return this.sourceOutputPort != null;
    }

    @Override
    public Collection<Precondition> getAllPreconditions() {
        return Collections.unmodifiableCollection(this.preconditions);
    }

    @Override
    public void registerMetaDataChangeListener(MetaDataChangeListener listener) {
        this.metaDataChangeListeners.add(listener);
    }

    @Override
    public void removeMetaDataChangeListener(MetaDataChangeListener listener) {
        this.metaDataChangeListeners.remove(listener);
    }

    private void informListenersOfChange(MetaData metaData) {
        for (MetaDataChangeListener listener : this.metaDataChangeListeners) {
            listener.informMetaDataChanged(metaData);
        }
    }
}

