/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.impl;

import com.rapidminer.gui.tools.dialogs.SelectionInputDialog;
import com.rapidminer.operator.IOMerger;
import com.rapidminer.operator.IOMultiplier;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortException;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.OperatorService;
import java.awt.Component;
import java.util.LinkedList;

public class CannotConnectPortException
extends PortException {
    private static final long serialVersionUID = 5242982041478562116L;
    private final OutputPort source;
    private final InputPort dest;
    private final String reason;
    private static final String[] OPTIONS = new String[]{I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.input.cannot_connect.option.disconnect_connect", new Object[0]), I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.input.cannot_connect.option.insert_multiplier", new Object[0]), I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.input.cannot_connect.option.dont_connect", new Object[0])};

    public CannotConnectPortException(OutputPort source, InputPort dest, InputPort sourceDest, OutputPort destSource) {
        super("Cannot connect " + source.getSpec() + " to " + dest.getSpec());
        this.source = source;
        this.dest = dest;
        this.reason = I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.input.cannot_connect.reason.both_connected", sourceDest.getSpec(), destSource.getSpec());
    }

    public CannotConnectPortException(OutputPort source, InputPort dest, InputPort sourceDest) {
        super("Cannot connect " + source.getSpec() + " to " + dest.getSpec());
        this.source = source;
        this.dest = dest;
        this.reason = I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.input.cannot_connect.reason.source_connected", sourceDest.getSpec());
    }

    public CannotConnectPortException(OutputPort source, InputPort dest, OutputPort destSource) {
        super("Cannot connect " + source.getSpec() + " to " + dest.getSpec());
        this.source = source;
        this.dest = dest;
        this.reason = I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.input.cannot_connect.reason.dest_connected", destSource.getSpec());
    }

    @Override
    public boolean hasRepairOptions() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showRepairDialog(Component component) {
        block15: {
            LinkedList<Port> toUnlock = new LinkedList<Port>();
            try {
                SelectionInputDialog dialog = new SelectionInputDialog("cannot_connect", (Object[])OPTIONS, (Object)OPTIONS[0]){
                    private static final long serialVersionUID = -5167666577334883031L;

                    @Override
                    protected String getInfoText() {
                        return I18N.getMessage(I18N.getGUIBundle(), this.getKey() + ".message", CannotConnectPortException.this.source.getSpec(), CannotConnectPortException.this.dest.getSpec(), CannotConnectPortException.this.reason);
                    }
                };
                dialog.setVisible(true);
                Object input = dialog.getInputSelection();
                if (input == null) {
                    return;
                }
                if (input == OPTIONS[0]) {
                    toUnlock.add(this.source);
                    toUnlock.add(this.dest);
                    this.source.lock();
                    this.dest.lock();
                    if (this.source.isConnected()) {
                        this.source.disconnect();
                    }
                    if (this.dest.isConnected()) {
                        this.dest.getSource().disconnect();
                    }
                    this.source.connectTo(this.dest);
                    break block15;
                }
                if (input == OPTIONS[1]) {
                    boolean repairSource = this.source.isConnected();
                    boolean repairDest = this.dest.isConnected();
                    if (repairSource) {
                        try {
                            InputPort oldDest = this.source.getDestination();
                            toUnlock.add(this.source);
                            toUnlock.add(this.source.getDestination());
                            this.source.getDestination().lock();
                            this.source.lock();
                            this.source.disconnect();
                            IOMultiplier multiplier = OperatorService.createOperator(IOMultiplier.class);
                            this.source.getPorts().getOwner().getConnectionContext().addOperator(multiplier);
                            this.source.connectTo((InputPort)multiplier.getInputPorts().getPortByIndex(0));
                            ((OutputPort)multiplier.getOutputPorts().getPortByIndex(0)).connectTo(oldDest);
                            ((OutputPort)multiplier.getOutputPorts().getPortByIndex(1)).connectTo(this.dest);
                        }
                        catch (OperatorCreationException e) {
                            throw new PortException("Cannot create multiplier: " + e);
                        }
                    }
                    if (!repairDest) break block15;
                    OutputPort oldSource = this.dest.getSource();
                    toUnlock.add(oldSource);
                    toUnlock.add(this.dest);
                    oldSource.lock();
                    this.dest.lock();
                    oldSource.disconnect();
                    try {
                        IOMerger merger = OperatorService.createOperator(IOMerger.class);
                        this.source.getPorts().getOwner().getConnectionContext().addOperator(merger);
                        oldSource.connectTo((InputPort)merger.getInputPorts().getPortByIndex(0));
                        this.source.connectTo((InputPort)merger.getInputPorts().getPortByIndex(1));
                        ((OutputPort)merger.getOutputPorts().getPortByIndex(0)).connectTo(this.dest);
                        break block15;
                    }
                    catch (OperatorCreationException e) {
                        throw new PortException("Cannot create multiplier: " + e);
                    }
                }
                return;
            }
            finally {
                for (Port port : toUnlock) {
                    port.unlock();
                }
            }
        }
    }
}

