/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.impl;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortException;
import com.rapidminer.operator.ports.PortExtender;
import com.rapidminer.operator.ports.PortOwner;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.impl.AbstractPort;
import com.rapidminer.tools.AbstractObservable;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public abstract class AbstractPorts<T extends Port>
extends AbstractObservable<Port>
implements Ports<T> {
    private final List<T> portList = new ArrayList<T>();
    private final Map<String, T> portMap = new HashMap<String, T>();
    private String[] portNames;
    private boolean portNamesValid = false;
    private final PortOwner owner;
    private final Observer<Port> delegatingObserver = new Observer<Port>(){

        @Override
        public void update(Observable<Port> observable, Port arg) {
            AbstractPorts.this.fireUpdate(arg);
        }
    };
    private List<PortExtender> portExtenders;

    public AbstractPorts(PortOwner owner) {
        this.owner = owner;
        this.portNamesValid = false;
    }

    private void updatePortNames() {
        if (!this.portNamesValid) {
            this.portNames = new String[this.portList.size()];
            int i = 0;
            for (Port port : this.portList) {
                this.portNames[i++] = port.getName();
            }
            this.portNamesValid = true;
        }
    }

    @Override
    public void addPort(T port) throws PortException {
        if (this.portMap.containsKey(port.getName())) {
            throw new PortException("Port name already used: " + port.getName());
        }
        assert (port.getPorts() == this);
        this.portList.add(port);
        this.portMap.put(port.getName(), port);
        this.portNamesValid = false;
        port.addObserver(this.delegatingObserver, false);
        this.fireUpdate(port);
    }

    @Override
    public void removePort(T port) throws PortException {
        if (!this.portList.contains(port) || port.getPorts() != this) {
            throw new PortException("Cannot remove " + port + ".");
        }
        if (port.isConnected()) {
            if (port instanceof OutputPort) {
                ((OutputPort)port).disconnect();
            } else {
                ((InputPort)port).getSource().disconnect();
            }
        }
        this.portList.remove(port);
        this.portMap.remove(port.getName());
        port.removeObserver(this.delegatingObserver);
        this.fireUpdate();
    }

    @Override
    public void removeAll() {
        while (this.getNumberOfPorts() != 0) {
            this.removePort(this.getPortByIndex(0));
        }
    }

    @Override
    public int getNumberOfPorts() {
        return this.portList.size();
    }

    @Override
    public T getPortByIndex(int index) {
        return (T)((Port)this.portList.get(index));
    }

    @Override
    public T getPortByName(String name) {
        Port port = (Port)this.portMap.get(name);
        if (port != null) {
            return (T)port;
        }
        LogService.getRoot().fine("Port '" + name + "' does not exist. Checking for extenders.");
        if (this.portExtenders != null) {
            for (PortExtender extender : this.portExtenders) {
                String prefix = extender.getNamePrefix();
                if (!name.startsWith(prefix)) continue;
                LogService.getRoot().fine("Found extender with prefix '" + prefix + "'. Trying to extend.");
                try {
                    int index = Integer.parseInt(name.substring(prefix.length()));
                    extender.ensureMinimumNumberOfPorts(index);
                    Port secondTry = (Port)this.portMap.get(name);
                    if (secondTry == null) {
                        LogService.getRoot().warning("Port extender " + prefix + " did not extend to size " + index + ".");
                    } else {
                        LogService.getRoot().fine("Port was created. Ports are now: " + this.getAllPorts());
                    }
                    return (T)secondTry;
                }
                catch (NumberFormatException e) {
                    LogService.getRoot().log(Level.WARNING, "Cannot extend " + prefix + ": " + e, e);
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public String[] getPortNames() {
        this.updatePortNames();
        return this.portNames;
    }

    @Override
    public List<T> getAllPorts() {
        return Collections.unmodifiableList(this.portList);
    }

    @Override
    public String getMetaDataDescription() {
        StringBuilder b = new StringBuilder();
        for (Port port : this.portList) {
            b.append(port.getName());
            b.append(": ");
            b.append(port.getMetaData());
            b.append("; ");
        }
        return b.toString();
    }

    @Override
    public PortOwner getOwner() {
        return this.owner;
    }

    @Override
    public boolean containsPort(T port) {
        return this.portList.contains(port);
    }

    @Override
    public void renamePort(T port, String newName) {
        if (this.portMap.containsKey(newName)) {
            throw new PortException("Port name already used: " + port.getName());
        }
        this.portMap.remove(port.getName());
        ((AbstractPort)port).setName(newName);
        this.portMap.put(newName, port);
    }

    @Override
    public void clear(int clearFlags) {
        for (Port port : this.getAllPorts()) {
            port.clear(clearFlags);
        }
    }

    @Override
    public IOContainer createIOContainer(boolean onlyConnected) {
        LinkedList<IOObject> output = new LinkedList<IOObject>();
        for (Port port : this.getAllPorts()) {
            IOObject data;
            if (onlyConnected && !port.isConnected() || (data = port.getAnyDataOrNull()) == null) continue;
            output.add(data);
        }
        return new IOContainer(output);
    }

    @Override
    public void pushDown(T port) {
        if (!this.portList.contains(port)) {
            throw new PortException("Cannot push down " + port.getName() + ": port does not belong to " + this);
        }
        this.portList.remove(port);
        this.portList.add(port);
    }

    @Override
    public void registerPortExtender(PortExtender extender) {
        if (this.portExtenders == null) {
            this.portExtenders = new LinkedList<PortExtender>();
        }
        this.portExtenders.add(extender);
    }

    @Override
    public void unlockPortExtenders() {
        if (this.portExtenders != null) {
            for (PortExtender extender : this.portExtenders) {
                extender.ensureMinimumNumberOfPorts(0);
            }
        }
    }

    @Override
    public void freeMemory() {
        for (Port inputPort : this.getAllPorts()) {
            inputPort.freeMemory();
        }
    }

    @Override
    public int getNumberOfConnectedPorts() {
        int count = 0;
        for (Port port : this.getAllPorts()) {
            if (!port.isConnected()) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String port : this.getPortNames()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(port);
        }
        return b.toString();
    }
}

