/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports.impl;

import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.tools.AbstractObservable;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractPort
extends AbstractObservable<Port>
implements Port {
    private final List<MetaDataError> errorList = new LinkedList<MetaDataError>();
    private final Ports<? extends Port> ports;
    private String name;
    private SoftReference<IOObject> weakDataReference;
    private IOObject hardDataReference;
    private final boolean simulatesStack;
    private boolean locked = false;

    protected AbstractPort(Ports<? extends Port> owner, String name, boolean simulatesStack) {
        this.name = name;
        this.ports = owner;
        this.simulatesStack = simulatesStack;
    }

    protected final void setData(IOObject object) {
        this.weakDataReference = new SoftReference<IOObject>(object);
        this.hardDataReference = object;
    }

    @Override
    public final <T extends IOObject> T getData() throws UserError {
        T data = this.getDataOrNull();
        if (data == null) {
            throw new UserError(this.getPorts().getOwner().getOperator(), 149, this.getSpec());
        }
        return data;
    }

    @Override
    public final IOObject getAnyDataOrNull() {
        if (this.hardDataReference != null) {
            return this.hardDataReference;
        }
        return this.weakDataReference != null ? this.weakDataReference.get() : null;
    }

    @Override
    public final <T extends IOObject> T getData(Class<T> desiredClass) throws UserError {
        IOObject data = this.getAnyDataOrNull();
        if (desiredClass.isAssignableFrom(data.getClass())) {
            return (T)((IOObject)desiredClass.cast(data));
        }
        throw new UserError(this.getPorts().getOwner().getOperator(), 156, RendererService.getName(data.getClass()), this.getName(), RendererService.getName(desiredClass));
    }

    @Override
    public final <T extends IOObject> T getDataOrNull() throws UserError {
        IOObject data = this.getAnyDataOrNull();
        try {
            return (T)data;
        }
        catch (ClassCastException e) {
            throw new UserError(this.getPorts().getOwner().getOperator(), 150, data.getClass().getSimpleName());
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.getSpec();
    }

    @Override
    public Ports<? extends Port> getPorts() {
        return this.ports;
    }

    @Override
    public String getShortName() {
        if (this.name.length() > 3) {
            return this.name.substring(0, 3);
        }
        return this.name;
    }

    protected void setName(String newName) {
        this.name = newName;
    }

    @Override
    public void addError(MetaDataError metaDataError) {
        this.errorList.add(metaDataError);
    }

    @Override
    public Collection<MetaDataError> getErrors() {
        return Collections.unmodifiableCollection(this.errorList);
    }

    @Override
    public void clear(int clearFlags) {
        if ((clearFlags & 1) > 0) {
            this.errorList.clear();
        }
        if ((clearFlags & 4) > 0) {
            this.weakDataReference = null;
            this.hardDataReference = null;
        }
    }

    @Override
    public List<QuickFix> collectQuickFixes() {
        LinkedList<QuickFix> fixes = new LinkedList<QuickFix>();
        for (MetaDataError error : this.getErrors()) {
            fixes.addAll(error.getQuickFixes());
        }
        Collections.sort(fixes);
        return fixes;
    }

    @Override
    public String getSpec() {
        if (this.getPorts() != null) {
            return this.getPorts().getOwner().getOperator().getName() + "." + this.getName();
        }
        return "DUMMY." + this.getName();
    }

    @Override
    public boolean simulatesStack() {
        return this.simulatesStack;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    @Override
    public void freeMemory() {
        this.hardDataReference = null;
    }
}

