/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports;

import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortExtender;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SinglePortExtender<T extends Port>
implements PortExtender {
    private final Ports<T> ports;
    private final String name;
    private int minNumber = 0;
    private boolean isChanging = false;
    private final List<T> managedPorts = new LinkedList<T>();
    private int runningId = 0;
    private final Observer<Port> observer = new Observer<Port>(){

        @Override
        public void update(Observable<Port> observable, Port arg) {
            SinglePortExtender.this.updatePorts();
        }
    };

    public SinglePortExtender(String name, Ports<T> ports) {
        this.ports = ports;
        this.name = name;
        ports.registerPortExtender(this);
    }

    private void updatePorts() {
        if (!this.isChanging) {
            this.isChanging = true;
            boolean first = true;
            Port foundDisconnected = null;
            Iterator<T> i = this.managedPorts.iterator();
            while (i.hasNext()) {
                Port port = (Port)i.next();
                if (port.isConnected() || port.isLocked()) continue;
                if (first) {
                    foundDisconnected = port;
                    first = false;
                    continue;
                }
                if (this.minNumber != 0) continue;
                this.deletePort(port);
                i.remove();
            }
            if (foundDisconnected == null || this.managedPorts.size() < this.minNumber) {
                do {
                    this.managedPorts.add(this.createPort());
                } while (this.managedPorts.size() < this.minNumber);
            } else if (this.minNumber == 0) {
                this.managedPorts.remove(foundDisconnected);
                this.managedPorts.add(foundDisconnected);
                this.ports.pushDown(foundDisconnected);
            }
            this.fixNames();
            this.isChanging = false;
        }
    }

    private void deletePort(T port) {
        if (port instanceof OutputPort && port.isConnected()) {
            ((OutputPort)port).disconnect();
        }
        this.ports.removePort(port);
    }

    protected T createPort() {
        ++this.runningId;
        T port = this.ports.createPort(this.name + " " + this.runningId);
        return port;
    }

    private void fixNames() {
        this.runningId = 0;
        for (Port port : this.managedPorts) {
            ++this.runningId;
            this.ports.renamePort(port, this.name + "_tmp_" + this.runningId);
        }
        this.runningId = 0;
        for (Port port : this.managedPorts) {
            ++this.runningId;
            this.ports.renamePort(port, this.name + " " + this.runningId);
        }
    }

    public void start() {
        this.managedPorts.add(this.createPort());
        this.fixNames();
        this.ports.addObserver(this.observer, false);
    }

    public List<T> getManagedPorts() {
        return Collections.unmodifiableList(this.managedPorts);
    }

    @Override
    public String getNamePrefix() {
        return this.name + " ";
    }

    @Override
    public void ensureMinimumNumberOfPorts(int minNumber) {
        this.minNumber = minNumber;
        this.updatePorts();
    }

    protected Ports<T> getPorts() {
        return this.ports;
    }
}

