/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortExtender;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PortPairExtender
implements PortExtender {
    private final String name;
    private final InputPorts inPorts;
    private final OutputPorts outPorts;
    private final List<PortPair> managedPairs = new LinkedList<PortPair>();
    private final MetaData preconditionMetaData;
    private boolean isChanging = false;
    private int runningId = 0;
    private final Observer<Port> observer = new Observer<Port>(){

        @Override
        public void update(Observable<Port> observable, Port arg) {
            PortPairExtender.this.updatePorts();
        }
    };
    private int minNumber = 0;

    public PortPairExtender(String name, InputPorts inPorts, OutputPorts outPorts) {
        this(name, inPorts, outPorts, null);
    }

    public PortPairExtender(String name, InputPorts inPorts, OutputPorts outPorts, MetaData preconditionMetaData) {
        this.name = name;
        this.inPorts = inPorts;
        this.outPorts = outPorts;
        this.preconditionMetaData = preconditionMetaData;
        inPorts.registerPortExtender(this);
        outPorts.registerPortExtender(this);
    }

    private void updatePorts() {
        if (!this.isChanging) {
            this.isChanging = true;
            boolean first = true;
            PortPair foundDisconnected = null;
            Iterator<PortPair> i = this.managedPairs.iterator();
            while (i.hasNext()) {
                PortPair pair = i.next();
                if (pair.inputPort.isConnected() || pair.inputPort.isLocked() || pair.outputPort.isConnected() || pair.outputPort.isLocked()) continue;
                if (first) {
                    first = false;
                    foundDisconnected = pair;
                    continue;
                }
                if (this.minNumber != 0) continue;
                this.deletePorts(pair);
                i.remove();
            }
            if (foundDisconnected == null || this.managedPairs.size() < this.minNumber) {
                do {
                    this.managedPairs.add(this.createPort());
                } while (this.managedPairs.size() < this.minNumber);
            } else if (this.minNumber == 0) {
                this.managedPairs.remove(foundDisconnected);
                this.managedPairs.add(foundDisconnected);
                this.inPorts.pushDown(foundDisconnected.getInputPort());
                this.outPorts.pushDown(foundDisconnected.getOutputPort());
            }
            this.fixNames();
            this.isChanging = false;
        }
    }

    public void start() {
        this.managedPairs.add(this.createPort());
        this.fixNames();
        this.inPorts.addObserver(this.observer, false);
        this.outPorts.addObserver(this.observer, false);
    }

    private PortPair createPort() {
        ++this.runningId;
        InputPort in = (InputPort)this.inPorts.createPassThroughPort(this.name + " " + this.runningId);
        if (this.preconditionMetaData != null) {
            in.addPrecondition(new SimplePrecondition(in, this.preconditionMetaData, false));
        }
        OutputPort out = (OutputPort)this.outPorts.createPassThroughPort(this.name + " " + this.runningId);
        return new PortPair(in, out);
    }

    private void deletePorts(PortPair pair) {
        if (pair.outputPort.isConnected()) {
            pair.outputPort.disconnect();
        }
        this.inPorts.removePort(pair.inputPort);
        this.outPorts.removePort(pair.outputPort);
    }

    private void fixNames() {
        this.runningId = 0;
        for (PortPair pair : this.managedPairs) {
            ++this.runningId;
            this.inPorts.renamePort(pair.inputPort, this.name + "_tmp_" + this.runningId);
            this.outPorts.renamePort(pair.outputPort, this.name + "_tmp_" + this.runningId);
        }
        this.runningId = 0;
        for (PortPair pair : this.managedPairs) {
            ++this.runningId;
            this.inPorts.renamePort(pair.inputPort, this.name + " " + this.runningId);
            this.outPorts.renamePort(pair.outputPort, this.name + " " + this.runningId);
        }
    }

    public MDTransformationRule makePassThroughRule() {
        return new MDTransformationRule(){

            @Override
            public void transformMD() {
                for (PortPair pair : PortPairExtender.this.managedPairs) {
                    MetaData inData = pair.inputPort.getMetaData();
                    if (inData != null) {
                        inData = PortPairExtender.this.transformMetaData(inData.clone());
                        inData.addToHistory(pair.getOutputPort());
                        pair.outputPort.deliverMD(inData);
                        continue;
                    }
                    pair.outputPort.deliverMD(null);
                }
            }
        };
    }

    protected MetaData transformMetaData(MetaData md) {
        return md;
    }

    public void passDataThrough() {
        for (PortPair pair : this.managedPairs) {
            IOObject data = pair.inputPort.getAnyDataOrNull();
            pair.outputPort.deliver(data);
        }
    }

    public void passCloneThrough() {
        for (PortPair pair : this.managedPairs) {
            IOObject data = pair.inputPort.getAnyDataOrNull();
            if (data != null) {
                pair.outputPort.deliver(data.copy());
                continue;
            }
            pair.outputPort.deliver(null);
        }
    }

    public List<PortPair> getManagedPairs() {
        return Collections.unmodifiableList(this.managedPairs);
    }

    public <T extends IOObject> List<T> getData() throws UserError {
        LinkedList results = new LinkedList();
        for (PortPair pair : this.managedPairs) {
            Object data = pair.inputPort.getDataOrNull();
            if (data == null) continue;
            results.add(data);
        }
        return results;
    }

    public <T extends IOObject> List<T> getOutputData() throws UserError {
        LinkedList results = new LinkedList();
        for (PortPair pair : this.managedPairs) {
            Object data = pair.outputPort.getDataOrNull();
            if (data == null) continue;
            results.add(data);
        }
        return results;
    }

    public void deliver(List<? extends IOObject> ioObjectList) {
        Iterator<PortPair> portIterator = this.getManagedPairs().iterator();
        for (IOObject iOObject : ioObjectList) {
            PortPair pair = portIterator.next();
            IOObject data = pair.inputPort.getAnyDataOrNull();
            while (data == null) {
                data = portIterator.next().inputPort.getAnyDataOrNull();
            }
            pair.outputPort.deliver(iOObject);
        }
    }

    @Override
    public String getNamePrefix() {
        return this.name + " ";
    }

    @Override
    public void ensureMinimumNumberOfPorts(int minNumber) {
        this.minNumber = minNumber;
        this.updatePorts();
    }

    public static class PortPair {
        private final InputPort inputPort;
        private final OutputPort outputPort;

        private PortPair(InputPort inputPort, OutputPort outputPort) {
            this.inputPort = inputPort;
            this.outputPort = outputPort;
        }

        public InputPort getInputPort() {
            return this.inputPort;
        }

        public OutputPort getOutputPort() {
            return this.outputPort;
        }
    }
}

