/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.SinglePortExtender;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.OneToManyPassThroughRule;
import java.util.List;

public class OutputPortExtender
extends SinglePortExtender<OutputPort> {
    public OutputPortExtender(String name, Ports<OutputPort> ports) {
        super(name, ports);
    }

    public MDTransformationRule makePassThroughRule(InputPort inputPort) {
        return new OneToManyPassThroughRule(inputPort, this.getManagedPorts());
    }

    public void deliverToAll(IOObject data, boolean clone) {
        for (OutputPort port : this.getManagedPorts()) {
            if (clone) {
                port.deliver(data.copy());
                continue;
            }
            port.deliver(data);
        }
    }

    public void deliver(List<IOObject> inputs) {
        int i = 0;
        for (OutputPort port : this.getManagedPorts()) {
            if (!port.isConnected()) continue;
            if (i >= inputs.size()) {
                this.getPorts().getOwner().getOperator().getLogger().fine("Insufficient input for " + port.getSpec());
            } else {
                IOObject input = inputs.get(i);
                port.deliver(input);
                String name = input instanceof ResultObject ? ((ResultObject)input).getName() : input.getClass().getName();
                name = name + " (" + input.getSource() + ")";
                this.getPorts().getOwner().getOperator().getLogger().fine("Delivering " + name + " to " + port.getSpec());
            }
            ++i;
        }
    }

    public void deliverMetaData(List<MetaData> inputMD) {
        int i = 0;
        for (OutputPort port : this.getManagedPorts()) {
            if (!port.isConnected()) continue;
            if (i < inputMD.size()) {
                port.deliverMD(inputMD.get(i));
            }
            ++i;
        }
    }
}

