/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports;

import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortExtender;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MultiPortPairExtender<S extends Port, M extends Port>
implements PortExtender {
    private final String name;
    private final Ports<S> singlePorts;
    private final ArrayList<Ports<M>> multiPortsList;
    private int minNumber = 0;
    private final List<MultiPortPair> managedPairs = new LinkedList<MultiPortPair>();
    private boolean isChanging = false;
    private int runningId = 0;
    private final Observer<Port> observer = new Observer<Port>(){

        @Override
        public void update(Observable<Port> observable, Port arg) {
            MultiPortPairExtender.this.updatePorts();
        }
    };

    public MultiPortPairExtender(String name, Ports<S> singlePorts, Ports<M>[] multiPortsList) {
        this.name = name;
        this.singlePorts = singlePorts;
        this.multiPortsList = new ArrayList<Ports<M>>(Arrays.asList(multiPortsList));
        singlePorts.registerPortExtender(this);
        for (Ports<M> ports : multiPortsList) {
            ports.registerPortExtender(this);
        }
    }

    public void addMultiPorts(Ports<M> multiPorts, int index) {
        this.multiPortsList.add(index, multiPorts);
        int id = 1;
        for (MultiPortPair pair : this.managedPairs) {
            pair.multiPorts.add(index, multiPorts.createPassThroughPort(this.name + " " + id));
            ++id;
        }
        multiPorts.addObserver(this.observer, false);
        this.updatePorts();
    }

    public void removeMultiPorts(int index) {
        Ports<M> oldPorts = this.multiPortsList.remove(index);
        oldPorts.removeObserver(this.observer);
        for (MultiPortPair pair : this.managedPairs) {
            pair.multiPorts.remove(index);
        }
        this.updatePorts();
    }

    private void updatePorts() {
        if (!this.isChanging) {
            this.isChanging = true;
            boolean first = true;
            MultiPortPair foundDisconnected = null;
            Iterator<MultiPortPair> i = this.managedPairs.iterator();
            while (i.hasNext()) {
                MultiPortPair pair = i.next();
                if (!pair.isDisconnected()) continue;
                if (first) {
                    first = false;
                    foundDisconnected = pair;
                    continue;
                }
                if (this.minNumber != 0) continue;
                this.deletePorts(pair);
                i.remove();
            }
            if (foundDisconnected == null || this.managedPairs.size() < this.minNumber) {
                do {
                    this.managedPairs.add(this.createPort());
                } while (this.managedPairs.size() < this.minNumber);
            } else if (this.minNumber == 0) {
                this.managedPairs.remove(foundDisconnected);
                this.managedPairs.add(foundDisconnected);
                this.singlePorts.pushDown(foundDisconnected.singlePort);
                for (int j = 0; j < this.multiPortsList.size(); ++j) {
                    this.multiPortsList.get(j).pushDown((Port)foundDisconnected.multiPorts.get(j));
                }
            }
            this.fixNames();
            this.isChanging = false;
        }
    }

    public void start() {
        this.managedPairs.add(this.createPort());
        this.fixNames();
        this.singlePorts.addObserver(this.observer, false);
        for (Ports<M> ports : this.multiPortsList) {
            ports.addObserver(this.observer, false);
        }
    }

    private MultiPortPair createPort() {
        ++this.runningId;
        S singlePort = this.singlePorts.createPassThroughPort(this.name + " " + this.runningId);
        ArrayList<M> newMultiPorts = new ArrayList<M>(this.multiPortsList.size());
        for (Ports<M> ports : this.multiPortsList) {
            M out = ports.createPassThroughPort(this.name + " " + this.runningId);
            newMultiPorts.add(out);
        }
        return new MultiPortPair(this, singlePort, newMultiPorts);
    }

    private void deletePorts(MultiPortPair pair) {
        this.singlePorts.removePort(pair.singlePort);
        for (Port multiPort : pair.multiPorts) {
            if (multiPort instanceof OutputPort && multiPort.isConnected()) {
                ((OutputPort)multiPort).disconnect();
            }
            multiPort.getPorts().removePort(multiPort);
        }
    }

    private void fixNames() {
        this.runningId = 0;
        for (MultiPortPair pair : this.managedPairs) {
            ++this.runningId;
            this.singlePorts.renamePort(pair.singlePort, this.name + "_tmp_" + this.runningId);
            for (Port port : pair.multiPorts) {
                port.getPorts().renamePort(port, this.name + "_tmp_" + this.runningId);
            }
        }
        this.runningId = 0;
        for (MultiPortPair pair : this.managedPairs) {
            ++this.runningId;
            this.singlePorts.renamePort(pair.singlePort, this.name + " " + this.runningId);
            for (Port port : pair.multiPorts) {
                port.getPorts().renamePort(port, this.name + " " + this.runningId);
            }
        }
    }

    protected List<MultiPortPair> getManagedPairs() {
        return this.managedPairs;
    }

    @Override
    public String getNamePrefix() {
        return this.name + " ";
    }

    @Override
    public void ensureMinimumNumberOfPorts(int minNumber) {
        this.minNumber = minNumber;
        this.updatePorts();
    }

    protected static class MultiPortPair {
        protected S singlePort;
        protected ArrayList<M> multiPorts;
        final /* synthetic */ MultiPortPairExtender this$0;

        public MultiPortPair(S singlePort, ArrayList<M> multiPorts) {
            this.this$0 = var1_1;
            this.singlePort = singlePort;
            this.multiPorts = multiPorts;
        }

        public boolean isDisconnected() {
            if (this.singlePort.isConnected() || this.singlePort.isLocked()) {
                return false;
            }
            for (Port port : this.multiPorts) {
                if (!port.isConnected() && !port.isLocked()) continue;
                return false;
            }
            return true;
        }
    }
}

