/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.SinglePortExtender;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.CollectionPrecondition;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.FlatteningPassThroughRule;
import com.rapidminer.operator.ports.metadata.InputMissingMetaDataError;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.ManyToOnePassThroughRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.Precondition;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class InputPortExtender
extends SinglePortExtender<InputPort> {
    private MetaData desiredMetaData;
    private int numberOfMandatory;

    public InputPortExtender(String name, Ports<InputPort> ports) {
        this(name, ports, null, 0);
    }

    public InputPortExtender(String name, Ports<InputPort> ports, MetaData desiredMetaData, boolean firstIsMandatory) {
        this(name, ports, desiredMetaData, firstIsMandatory ? 1 : 0);
    }

    public InputPortExtender(String name, Ports<InputPort> ports, MetaData desiredMetaData, int numberOfMandatory) {
        super(name, ports);
        this.desiredMetaData = desiredMetaData;
        this.numberOfMandatory = numberOfMandatory;
    }

    @Override
    protected InputPort createPort() {
        InputPort port = (InputPort)super.createPort();
        Precondition precondition = this.makePrecondition(port, this.getManagedPorts().size());
        if (precondition != null) {
            port.addPrecondition(new CollectionPrecondition(precondition));
        }
        return port;
    }

    public <T extends IOObject> List<T> getData(boolean unfold) {
        LinkedList<IOObject> results = new LinkedList<IOObject>();
        for (InputPort port : this.getManagedPorts()) {
            IOObject data = port.getAnyDataOrNull();
            if (data == null) continue;
            if (unfold && data instanceof IOObjectCollection) {
                this.unfold((IOObjectCollection)data, results);
                continue;
            }
            results.add(data);
        }
        return results;
    }

    private <T> void unfold(IOObjectCollection<IOObject> data, List<T> results) {
        for (IOObject obj : data.getObjects()) {
            if (obj instanceof IOObjectCollection) {
                this.unfold((IOObjectCollection)obj, results);
                continue;
            }
            results.add(obj);
        }
    }

    public List<MetaData> getMetaData(boolean unfold) {
        LinkedList<MetaData> results = new LinkedList<MetaData>();
        for (InputPort port : this.getManagedPorts()) {
            MetaData data = port.getMetaData();
            if (data == null) continue;
            if (unfold && data instanceof CollectionMetaData) {
                results.add(((CollectionMetaData)data).getElementMetaDataRecursive());
                continue;
            }
            results.add(data);
        }
        return results;
    }

    protected Precondition makePrecondition(InputPort port, int portIndex) {
        return this.makePrecondition(port);
    }

    protected Precondition makePrecondition(final InputPort port) {
        if (this.desiredMetaData != null) {
            return new Precondition(){

                @Override
                public void assumeSatisfied() {
                    if (!InputPortExtender.this.getManagedPorts().isEmpty()) {
                        ((InputPort)InputPortExtender.this.getManagedPorts().iterator().next()).receiveMD(InputPortExtender.this.desiredMetaData);
                    }
                }

                @Override
                public void check(MetaData metaData) {
                    if (!InputPortExtender.this.getManagedPorts().isEmpty()) {
                        boolean isMandatory;
                        int portIndex = InputPortExtender.this.getManagedPorts().indexOf(port);
                        boolean bl = isMandatory = portIndex < InputPortExtender.this.numberOfMandatory;
                        if (metaData == null && isMandatory) {
                            port.addError(new InputMissingMetaDataError(port, InputPortExtender.this.desiredMetaData.getObjectClass(), null));
                        }
                        if (metaData != null && !InputPortExtender.this.desiredMetaData.isCompatible(metaData, CompatibilityLevel.VERSION_5)) {
                            Collection<MetaDataError> errors = InputPortExtender.this.desiredMetaData.getErrorsForInput(port, metaData, CompatibilityLevel.VERSION_5);
                            for (MetaDataError error : errors) {
                                port.addError(error);
                            }
                        }
                    }
                }

                @Override
                public String getDescription() {
                    return "requires " + (InputPortExtender.this.numberOfMandatory > 0 ? " at least " + InputPortExtender.this.numberOfMandatory + " " : "") + InputPortExtender.this.desiredMetaData.getDescription();
                }

                @Override
                public MetaData getExpectedMetaData() {
                    return InputPortExtender.this.desiredMetaData;
                }

                @Override
                public boolean isCompatible(MetaData input, CompatibilityLevel level) {
                    return InputPortExtender.this.desiredMetaData.isCompatible(input, level);
                }
            };
        }
        return null;
    }

    public MDTransformationRule makePassThroughRule(OutputPort outputPort) {
        return new ManyToOnePassThroughRule(this.getManagedPorts(), outputPort);
    }

    public MDTransformationRule makeFlatteningPassThroughRule(OutputPort outputPort) {
        return new FlatteningPassThroughRule(this.getManagedPorts(), outputPort);
    }
}

