/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports;

import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.PortOwner;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;

public class DummyPortPairExtender
extends PortPairExtender {
    public DummyPortPairExtender(String name, InputPorts inPorts, OutputPorts outPorts) {
        super(name, inPorts, outPorts);
    }

    @Override
    public MDTransformationRule makePassThroughRule() {
        return new MDTransformationRule(){

            @Override
            public void transformMD() {
                boolean somethingConnected = false;
                for (PortPairExtender.PortPair pair : DummyPortPairExtender.this.getManagedPairs()) {
                    somethingConnected |= pair.getInputPort().isConnected() || pair.getOutputPort().isConnected();
                    MetaData inData = pair.getInputPort().getMetaData();
                    if (inData != null) {
                        inData = DummyPortPairExtender.this.transformMetaData(inData.clone());
                        inData.addToHistory(pair.getOutputPort());
                        pair.getOutputPort().deliverMD(inData);
                        continue;
                    }
                    pair.getOutputPort().deliverMD(null);
                }
                if (!somethingConnected) {
                    PortOwner owner = DummyPortPairExtender.this.getManagedPairs().get(0).getInputPort().getPorts().getOwner();
                    owner.getOperator().addError(new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, owner, "execution_order_undefined", new Object[0]));
                }
            }
        };
    }
}

