/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.ports;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.CollectionMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;

public class CollectingPortPairExtender
extends PortPairExtender {
    public CollectingPortPairExtender(String name, InputPorts inPorts, OutputPorts outPorts) {
        super(name, inPorts, outPorts);
    }

    @Override
    protected MetaData transformMetaData(MetaData md) {
        return new CollectionMetaData(md);
    }

    public void reset() {
        for (PortPairExtender.PortPair pair : this.getManagedPairs()) {
            if (pair.getInputPort().isConnected()) {
                pair.getOutputPort().deliver(new IOObjectCollection());
                continue;
            }
            pair.getOutputPort().clear(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect() {
        CollectingPortPairExtender collectingPortPairExtender = this;
        synchronized (collectingPortPairExtender) {
            for (PortPairExtender.PortPair pair : this.getManagedPairs()) {
                IOObject data = pair.getInputPort().getAnyDataOrNull();
                if (data == null) continue;
                IOObject output = pair.getOutputPort().getAnyDataOrNull();
                if (output == null) {
                    IOObjectCollection<IOObject> collection = new IOObjectCollection<IOObject>();
                    collection.add(data);
                    pair.getOutputPort().deliver(collection);
                    continue;
                }
                if (output instanceof IOObjectCollection) {
                    ((IOObjectCollection)output).add(data);
                    pair.getOutputPort().deliver(output);
                    continue;
                }
                pair.getOutputPort().getPorts().getOwner().getOperator().getLogger().warning("Cannot collect output at " + pair.getOutputPort().getSpec() + ": data is of type " + output.getClass().getName() + ".");
            }
        }
    }
}

