/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance.cost;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.performance.cost.RankingCriterion;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import java.util.List;

public class RankingEvaluator
extends Operator {
    private static final String PARAMETER_RANKING_COSTS = "ranking_costs";
    private static final String PARAMETER_RANK_START = "rank_interval_start";
    private static final String PARAMETER_RANK_COST = "costs";
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance");
    private PerformanceVector performance = null;

    public RankingEvaluator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, 0, "label"));
        this.getTransformer().addGenerationRule(this.performanceOutput, PerformanceVector.class);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.addValue(new ValueDouble("ranking_cost", "blubb"){

            @Override
            public double getDoubleValue() {
                if (RankingEvaluator.this.performance == null) {
                    return Double.NaN;
                }
                PerformanceCriterion c = RankingEvaluator.this.performance.getCriterion("RankingCosts");
                if (c != null) {
                    return c.getAverage();
                }
                return Double.NaN;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label == null) throw new UserError((Operator)this, 105);
        if (!label.isNominal()) throw new UserError((Operator)this, 101, "CostEvaluator", label.getName());
        List<String[]> rankings = this.getParameterList(PARAMETER_RANKING_COSTS);
        int i = 0;
        double[] costs = new double[rankings.size()];
        int[] indices = new int[rankings.size()];
        for (String[] pair : rankings) {
            indices[i] = Integer.valueOf(pair[0]);
            costs[i] = Double.valueOf(pair[1]);
            ++i;
        }
        RankingCriterion criterion = new RankingCriterion(indices, costs, exampleSet);
        this.performance = new PerformanceVector();
        this.performance.addCriterion(criterion);
        criterion.startCounting(exampleSet, false);
        for (Example example : exampleSet) {
            ((MeasuredPerformance)criterion).countExample(example);
        }
        this.exampleSetOutput.deliver(exampleSet);
        this.performanceOutput.deliver(this.performance);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeList(PARAMETER_RANKING_COSTS, "This parameter defines the costs when the real call isn't the one with the highest confidence.", (ParameterType)new ParameterTypeInt(PARAMETER_RANK_START, "This is the first rank of the interval between this and the nearest greater defined rank. Each of these ranks get assigned this value. Rank counting starts with 0.", 0, Integer.MAX_VALUE), (ParameterType)new ParameterTypeDouble(PARAMETER_RANK_COST, "This is the cost of all ranks within this range.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), false));
        return types;
    }
}

