/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance.cost;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;
import java.util.HashMap;

public class RankingCriterion
extends MeasuredPerformance {
    private static final long serialVersionUID = -7466139591781285005L;
    private double costs;
    private Attribute label;
    private Attribute[] confidenceAttributes;
    private double exampleCount;
    private int[] rankIntervallStarts;
    private double[] rankIntervallCost;
    private HashMap<String, Integer> confidenceAttributesMap = new HashMap();

    public RankingCriterion(int[] rankIntervallStarts, double[] rankIntervallCost, ExampleSet exampleSet) {
        this.label = exampleSet.getAttributes().getLabel();
        this.rankIntervallStarts = rankIntervallStarts;
        this.rankIntervallCost = rankIntervallCost;
        this.confidenceAttributes = new Attribute[this.label.getMapping().size()];
        int i = 0;
        for (String labelValue : this.label.getMapping().getValues()) {
            this.confidenceAttributes[i] = exampleSet.getAttributes().getSpecial("confidence_" + labelValue);
            this.confidenceAttributesMap.put(labelValue, i);
            ++i;
        }
        this.costs = 0.0;
    }

    @Override
    public String getDescription() {
        return "This Criterion delievers the ranking costs";
    }

    @Override
    public String getName() {
        return "RankingCosts";
    }

    @Override
    public void countExample(Example example) {
        int intervallIndex;
        int indexOfCorrect = this.confidenceAttributesMap.get(example.getNominalValue(this.label));
        double confidenceOfCorrect = example.getValue(this.confidenceAttributes[indexOfCorrect]);
        int rank = 0;
        for (int i = 0; i < this.confidenceAttributes.length; ++i) {
            double currentConfidence = example.getValue(this.confidenceAttributes[i]);
            if (!(currentConfidence > confidenceOfCorrect)) continue;
            ++rank;
        }
        for (intervallIndex = 0; intervallIndex < this.rankIntervallStarts.length - 1 && this.rankIntervallStarts[intervallIndex + 1] <= rank; ++intervallIndex) {
        }
        if (rank >= this.rankIntervallStarts[0]) {
            this.costs += this.rankIntervallCost[intervallIndex];
        }
        this.exampleCount += 1.0;
    }

    @Override
    public double getExampleCount() {
        return this.exampleCount;
    }

    @Override
    public double getFitness() {
        return -this.costs;
    }

    @Override
    protected void buildSingleAverage(Averagable averagable) {
    }

    @Override
    public double getMikroAverage() {
        return this.costs / this.exampleCount;
    }

    @Override
    public double getMikroVariance() {
        return 0.0;
    }
}

