/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance.cost;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.performance.cost.ClassificationCostCriterion;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeMatrix;
import java.util.List;

public class CostEvaluator
extends Operator {
    private static final String PARAMETER_COST_MATRIX = "cost_matrix";
    private static final String PARAMETER_KEEP_EXAMPLE_SET = "keep_exampleSet";
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance");
    private double lastCosts = Double.NaN;

    public CostEvaluator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, 0, "label"));
        this.getTransformer().addGenerationRule(this.performanceOutput, PerformanceVector.class);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.addValue(new ValueDouble("costs", "The last costs."){

            @Override
            public double getDoubleValue() {
                return CostEvaluator.this.lastCosts;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label == null) throw new UserError((Operator)this, 105);
        if (!label.isNominal()) throw new UserError((Operator)this, 101, "CostEvaluator", label.getName());
        double[][] costMatrix = this.getParameterAsMatrix(PARAMETER_COST_MATRIX);
        ClassificationCostCriterion criterion = new ClassificationCostCriterion(costMatrix, label, exampleSet.getAttributes().getPredictedLabel());
        PerformanceVector performance = new PerformanceVector();
        performance.addCriterion(criterion);
        criterion.startCounting(exampleSet, false);
        for (Example example : exampleSet) {
            ((MeasuredPerformance)criterion).countExample(example);
        }
        this.lastCosts = criterion.getAverage();
        this.exampleSetOutput.deliver(exampleSet);
        this.performanceOutput.deliver(performance);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_KEEP_EXAMPLE_SET, "Indicates if the example set should be kept.", false);
        type.setHidden(true);
        types.add(type);
        types.add(new ParameterTypeMatrix(PARAMETER_COST_MATRIX, "The matrix of missclassification costs. Columns and Rows in order of internal mapping.", "Cost Matrix", "Predicted Class", "True Class", true, false));
        return types;
    }
}

