/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance.cost;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;

public class ClassificationCostCriterion
extends MeasuredPerformance {
    private static final long serialVersionUID = -7466139591781285005L;
    private double[][] costMatrix;
    private double exampleCount;
    private double costs;
    Attribute label;
    Attribute predictedLabel;

    public ClassificationCostCriterion(double[][] costMatrix, Attribute label, Attribute predictedLabel) {
        this.costMatrix = costMatrix;
        this.label = label;
        this.predictedLabel = predictedLabel;
        this.exampleCount = 0.0;
        this.costs = 0.0;
    }

    @Override
    public String getDescription() {
        return "This Criterion delievers the misclassificationCosts";
    }

    @Override
    public String getName() {
        return "Misclassificationcosts";
    }

    @Override
    public void countExample(Example example) {
        this.exampleCount += 1.0;
        this.costs += this.costMatrix[(int)example.getValue(this.predictedLabel)][(int)example.getValue(this.label)];
    }

    @Override
    public double getExampleCount() {
        return this.exampleCount;
    }

    @Override
    public double getFitness() {
        return -this.costs;
    }

    @Override
    protected void buildSingleAverage(Averagable averagable) {
    }

    @Override
    public double getMikroAverage() {
        return this.costs / this.exampleCount;
    }

    @Override
    public double getMikroVariance() {
        return 0.0;
    }
}

