/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.HashMap;
import java.util.List;

public class WeightedPerformanceCreator
extends Operator {
    private InputPort performanceInput = (InputPort)this.getInputPorts().createPort("performance");
    private OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance");
    public static final String PARAMETER_DEFAULT_WEIGHT = "default_weight";
    public static final String PARAMETER_CRITERIA_WEIGHTS = "criteria_weights";

    public WeightedPerformanceCreator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.performanceInput, this.performanceOutput);
    }

    @Override
    public void doWork() throws OperatorException {
        PerformanceVector inputPerformance = (PerformanceVector)this.performanceInput.getData();
        HashMap<String, Double> weightMap = new HashMap<String, Double>();
        List<String[]> weightList = this.getParameterList(PARAMETER_CRITERIA_WEIGHTS);
        for (String[] entry : weightList) {
            String criterionName = entry[0];
            Double criterionWeight = Double.valueOf(entry[1]);
            weightMap.put(criterionName, criterionWeight);
        }
        double defaultWeight = this.getParameterAsDouble(PARAMETER_DEFAULT_WEIGHT);
        double sum = 0.0;
        double weightSum = 0.0;
        for (int j = 0; j < inputPerformance.getSize(); ++j) {
            PerformanceCriterion pc = inputPerformance.getCriterion(j);
            Double weightObject = (Double)weightMap.get(pc.getName());
            double weight = weightObject != null ? weightObject : defaultWeight;
            sum += weight * pc.getFitness();
            weightSum += weight;
        }
        PerformanceVector performance = new PerformanceVector();
        performance.addCriterion(new EstimatedPerformance("weighted_performance", sum /= weightSum, 1, false));
        this.performanceOutput.deliver(performance);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_DEFAULT_WEIGHT, "The default weight for all criteria not specified in the list 'criteria_weights'.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeList(PARAMETER_CRITERIA_WEIGHTS, "The weights for several performance criteria. Criteria weights not defined in this list are set to 'default_weight'.", (ParameterType)new ParameterTypeString("criteria_name", "The name of the criteria."), (ParameterType)new ParameterTypeDouble("criteria_weight", "The weight for this criteria.", 0.0, Double.POSITIVE_INFINITY, 1.0)));
        return types;
    }
}

