/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.learner.functions.kernel.KernelModel;
import com.rapidminer.operator.learner.functions.kernel.SupportVector;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.MDLCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import java.util.List;

public class SupportVectorCounter
extends Operator {
    public static final String PARAMETER_OPTIMIZATION_DIRECTION = "optimization_direction";
    private double lastCount = Double.NaN;
    private InputPort modelInput = this.getInputPorts().createPort("model", KernelModel.class);
    private InputPort performanceInput = (InputPort)this.getInputPorts().createPort("performance vector");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");
    private OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance vector");

    public SupportVectorCounter(OperatorDescription description) {
        super(description);
        this.getTransformer().addGenerationRule(this.performanceOutput, PerformanceVector.class);
        this.getTransformer().addPassThroughRule(this.modelInput, this.modelOutput);
        this.addValue(new ValueDouble("support_vectors", "The number of the currently used support vectors."){

            @Override
            public double getDoubleValue() {
                return SupportVectorCounter.this.lastCount;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        Model model = (Model)this.modelInput.getData();
        if (!(model instanceof KernelModel)) {
            throw new UserError((Operator)this, 122, "'support vector based model (kernel model)'");
        }
        PerformanceVector inputPerformance = (PerformanceVector)this.performanceInput.getDataOrNull();
        PerformanceVector performance = this.count((KernelModel)model, inputPerformance);
        this.modelOutput.deliver(model);
        this.performanceOutput.deliver(performance);
    }

    private PerformanceVector count(KernelModel model, PerformanceVector performanceCriteria) throws OperatorException {
        if (performanceCriteria == null) {
            performanceCriteria = new PerformanceVector();
        }
        this.lastCount = 0.0;
        int svNumber = model.getNumberOfSupportVectors();
        for (int i = 0; i < svNumber; ++i) {
            SupportVector sv = model.getSupportVector(i);
            if (!(Math.abs(sv.getAlpha()) > 0.0)) continue;
            this.lastCount += 1.0;
        }
        EstimatedPerformance svCriterion = new EstimatedPerformance("number_of_support_vectors", this.lastCount, 1, this.getParameterAsInt(PARAMETER_OPTIMIZATION_DIRECTION) == 0);
        performanceCriteria.addCriterion(svCriterion);
        return performanceCriteria;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_OPTIMIZATION_DIRECTION, "Indicates if the fitness should be maximal for the maximal or the minimal number of support vectors.", MDLCriterion.DIRECTIONS, 0));
        return types;
    }
}

