/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.operator.performance.SimpleCriterion;
import com.rapidminer.tools.Tools;

public class StrictRelativeError
extends SimpleCriterion {
    private static final long serialVersionUID = 8055914052886853327L;

    public StrictRelativeError() {
    }

    public StrictRelativeError(StrictRelativeError sc) {
        super(sc);
    }

    @Override
    public double countExample(double label, double predictedLabel) {
        double diff = Math.abs(label - predictedLabel);
        double absLabel = Math.abs(label);
        double absPrediction = Math.abs(predictedLabel);
        if (Tools.isZero(diff)) {
            return 0.0;
        }
        double min = Math.min(absLabel, absPrediction);
        if (Tools.isZero(min)) {
            return Double.POSITIVE_INFINITY;
        }
        return diff / min;
    }

    @Override
    public boolean formatPercent() {
        return true;
    }

    @Override
    public String getName() {
        return "relative_error_strict";
    }

    @Override
    public String getDescription() {
        return "Average strict relative error (average of absolute deviation of the prediction from the actual value divided by minimum of the actual value and the prediction)";
    }
}

