/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.AbstractPerformanceEvaluator;
import com.rapidminer.operator.performance.AreaUnderCurve;
import com.rapidminer.operator.performance.BinaryClassificationPerformance;
import com.rapidminer.operator.performance.MultiClassificationPerformance;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.RootMeanSquaredError;
import com.rapidminer.operator.performance.SquaredError;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.ROCBias;
import java.util.LinkedList;
import java.util.List;

public class SimplePerformanceEvaluator
extends AbstractPerformanceEvaluator {
    private ExampleSet testSet = null;

    public SimplePerformanceEvaluator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected void checkCompatibility(ExampleSet exampleSet) throws OperatorException {
    }

    @Override
    protected double[] getClassWeights(Attribute label) throws UndefinedParameterError {
        return null;
    }

    @Override
    protected void init(ExampleSet testSet) {
        this.testSet = testSet;
    }

    @Override
    protected boolean showSkipNaNLabelsParameter() {
        return false;
    }

    @Override
    protected boolean showComparatorParameter() {
        return false;
    }

    @Override
    public List<PerformanceCriterion> getCriteria() {
        Attribute label;
        LinkedList<PerformanceCriterion> allCriteria = new LinkedList<PerformanceCriterion>();
        if (this.testSet != null && (label = this.testSet.getAttributes().getLabel()) != null) {
            if (label.isNominal()) {
                if (label.getMapping().size() == 2) {
                    allCriteria.add(new MultiClassificationPerformance(0));
                    allCriteria.add(new BinaryClassificationPerformance(0));
                    allCriteria.add(new BinaryClassificationPerformance(1));
                    allCriteria.add(new AreaUnderCurve(ROCBias.OPTIMISTIC));
                    allCriteria.add(new AreaUnderCurve(ROCBias.NEUTRAL));
                    allCriteria.add(new AreaUnderCurve(ROCBias.PESSIMISTIC));
                } else {
                    allCriteria.add(new MultiClassificationPerformance(0));
                    allCriteria.add(new MultiClassificationPerformance(2));
                }
            } else {
                allCriteria.add(new RootMeanSquaredError());
                allCriteria.add(new SquaredError());
            }
        }
        this.testSet = null;
        return allCriteria;
    }

    @Override
    protected boolean canEvaluate(int valueType) {
        return true;
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case NUMERICAL_LABEL: 
            case BINOMINAL_LABEL: 
            case POLYNOMINAL_LABEL: 
            case ONE_CLASS_LABEL: {
                return true;
            }
            case POLYNOMINAL_ATTRIBUTES: 
            case BINOMINAL_ATTRIBUTES: 
            case NUMERICAL_ATTRIBUTES: 
            case WEIGHTED_EXAMPLES: 
            case MISSING_VALUES: {
                return true;
            }
        }
        return false;
    }
}

