/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.operator.performance.SimpleCriterion;
import com.rapidminer.tools.Tools;

public class RelativeError
extends SimpleCriterion {
    private static final long serialVersionUID = 203943264201733699L;

    public RelativeError() {
    }

    public RelativeError(RelativeError sc) {
        super(sc);
    }

    @Override
    public double countExample(double label, double predictedLabel) {
        double diff = Math.abs(label - predictedLabel);
        double absLabel = Math.abs(label);
        if (Tools.isZero(absLabel)) {
            return Double.NaN;
        }
        return diff / absLabel;
    }

    @Override
    public boolean formatPercent() {
        return true;
    }

    @Override
    public String getName() {
        return "relative_error";
    }

    @Override
    public String getDescription() {
        return "Average relative error (average of absolute deviation of the prediction from the actual value divided by actual value)";
    }
}

