/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.AbsoluteError;
import com.rapidminer.operator.performance.AbstractPerformanceEvaluator;
import com.rapidminer.operator.performance.CorrelationCriterion;
import com.rapidminer.operator.performance.LenientRelativeError;
import com.rapidminer.operator.performance.NormalizedAbsoluteError;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PredictionAverage;
import com.rapidminer.operator.performance.RankCorrelation;
import com.rapidminer.operator.performance.RelativeError;
import com.rapidminer.operator.performance.RootMeanSquaredError;
import com.rapidminer.operator.performance.RootRelativeSquaredError;
import com.rapidminer.operator.performance.SquaredCorrelationCriterion;
import com.rapidminer.operator.performance.SquaredError;
import com.rapidminer.operator.performance.StrictRelativeError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import java.util.LinkedList;
import java.util.List;

public class RegressionPerformanceEvaluator
extends AbstractPerformanceEvaluator {
    private static final Class[] SIMPLE_CRITERIA_CLASSES = new Class[]{RootMeanSquaredError.class, AbsoluteError.class, RelativeError.class, LenientRelativeError.class, StrictRelativeError.class, NormalizedAbsoluteError.class, RootRelativeSquaredError.class, SquaredError.class, CorrelationCriterion.class, SquaredCorrelationCriterion.class, PredictionAverage.class};

    public RegressionPerformanceEvaluator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected void checkCompatibility(ExampleSet exampleSet) throws OperatorException {
        Tools.isLabelled(exampleSet);
        Tools.isNonEmpty(exampleSet);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (!label.isNumerical()) {
            throw new UserError((Operator)this, 102, "the calculation of performance criteria for regression tasks", label.getName());
        }
    }

    @Override
    protected double[] getClassWeights(Attribute label) {
        return null;
    }

    @Override
    public List<PerformanceCriterion> getCriteria() {
        int i;
        LinkedList<PerformanceCriterion> allCriteria = new LinkedList<PerformanceCriterion>();
        for (i = 0; i < SIMPLE_CRITERIA_CLASSES.length; ++i) {
            try {
                allCriteria.add((PerformanceCriterion)SIMPLE_CRITERIA_CLASSES[i].newInstance());
                continue;
            }
            catch (InstantiationException e) {
                LogService.getGlobal().logError("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ". Skipping...");
                continue;
            }
            catch (IllegalAccessException e) {
                LogService.getGlobal().logError("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ". Skipping...");
            }
        }
        for (i = 0; i < RankCorrelation.NAMES.length; ++i) {
            allCriteria.add(new RankCorrelation(i));
        }
        return allCriteria;
    }

    @Override
    protected boolean canEvaluate(int valueType) {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 2);
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case NUMERICAL_LABEL: {
                return true;
            }
            case BINOMINAL_LABEL: 
            case POLYNOMINAL_LABEL: 
            case ONE_CLASS_LABEL: {
                return false;
            }
            case POLYNOMINAL_ATTRIBUTES: 
            case BINOMINAL_ATTRIBUTES: 
            case NUMERICAL_ATTRIBUTES: 
            case WEIGHTED_EXAMPLES: 
            case MISSING_VALUES: {
                return true;
            }
        }
        return false;
    }
}

