/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;

public class PredictionAverage
extends MeasuredPerformance {
    private static final long serialVersionUID = -5316112625406102611L;
    private double sum;
    private double squaredSum;
    private double count;
    private Attribute labelAttribute;
    private Attribute weightAttribute;

    public PredictionAverage() {
    }

    public PredictionAverage(PredictionAverage pa) {
        super(pa);
        this.sum = pa.sum;
        this.squaredSum = pa.squaredSum;
        this.count = pa.count;
        this.labelAttribute = (Attribute)pa.labelAttribute.clone();
        if (pa.weightAttribute != null) {
            this.weightAttribute = (Attribute)pa.weightAttribute.clone();
        }
    }

    @Override
    public double getExampleCount() {
        return this.count;
    }

    @Override
    public void countExample(Example example) {
        double weight = 1.0;
        if (this.weightAttribute != null) {
            weight = example.getValue(this.weightAttribute);
        }
        this.count += weight;
        double v = example.getLabel();
        if (!Double.isNaN(v)) {
            this.sum += v * weight;
            this.squaredSum += v * v * weight * weight;
        }
    }

    @Override
    public double getMikroAverage() {
        return this.sum / this.count;
    }

    @Override
    public double getMikroVariance() {
        double avg = this.getMikroAverage();
        return this.squaredSum / this.count - avg * avg;
    }

    @Override
    public void startCounting(ExampleSet set, boolean useExampleWeights) throws OperatorException {
        super.startCounting(set, useExampleWeights);
        this.count = 0.0;
        this.sum = 0.0;
        this.labelAttribute = set.getAttributes().getLabel();
        if (useExampleWeights) {
            this.weightAttribute = set.getAttributes().getWeight();
        }
    }

    @Override
    public String getName() {
        return "prediction_average";
    }

    @Override
    public double getFitness() {
        return 0.0;
    }

    @Override
    public void buildSingleAverage(Averagable performance) {
        PredictionAverage other = (PredictionAverage)performance;
        this.sum += other.sum;
        this.squaredSum += other.squaredSum;
        this.count += other.count;
    }

    @Override
    public String getDescription() {
        return "This is not a real performance measure, but merely the average of the predicted labels.";
    }
}

