/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.AbsoluteError;
import com.rapidminer.operator.performance.AbstractPerformanceEvaluator;
import com.rapidminer.operator.performance.CorrelationCriterion;
import com.rapidminer.operator.performance.CrossEntropy;
import com.rapidminer.operator.performance.LenientRelativeError;
import com.rapidminer.operator.performance.LogisticLoss;
import com.rapidminer.operator.performance.Margin;
import com.rapidminer.operator.performance.MultiClassificationPerformance;
import com.rapidminer.operator.performance.NormalizedAbsoluteError;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.RankCorrelation;
import com.rapidminer.operator.performance.RelativeError;
import com.rapidminer.operator.performance.RootMeanSquaredError;
import com.rapidminer.operator.performance.RootRelativeSquaredError;
import com.rapidminer.operator.performance.SoftMarginLoss;
import com.rapidminer.operator.performance.SquaredCorrelationCriterion;
import com.rapidminer.operator.performance.SquaredError;
import com.rapidminer.operator.performance.StrictRelativeError;
import com.rapidminer.operator.performance.WeightedMultiClassPerformance;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import java.util.LinkedList;
import java.util.List;

public class PolynominalClassificationPerformanceEvaluator
extends AbstractPerformanceEvaluator {
    public static final String PARAMETER_CLASS_WEIGHTS = "class_weights";
    private static final Class[] SIMPLE_CRITERIA_CLASSES = new Class[]{AbsoluteError.class, RelativeError.class, LenientRelativeError.class, StrictRelativeError.class, NormalizedAbsoluteError.class, RootMeanSquaredError.class, RootRelativeSquaredError.class, SquaredError.class, CorrelationCriterion.class, SquaredCorrelationCriterion.class, CrossEntropy.class, Margin.class, SoftMarginLoss.class, LogisticLoss.class};

    public PolynominalClassificationPerformanceEvaluator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected void checkCompatibility(ExampleSet exampleSet) throws OperatorException {
        Tools.isLabelled(exampleSet);
        Tools.isNonEmpty(exampleSet);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (!label.isNominal()) {
            throw new UserError((Operator)this, 101, "the calculation of performance criteria for classification tasks", label.getName());
        }
    }

    @Override
    protected double[] getClassWeights(Attribute label) throws UndefinedParameterError {
        double[] weights = null;
        if (this.isParameterSet(PARAMETER_CLASS_WEIGHTS)) {
            weights = new double[label.getMapping().size()];
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = 1.0;
            }
            List<String[]> classWeights = this.getParameterList(PARAMETER_CLASS_WEIGHTS);
            for (String[] classWeightArray : classWeights) {
                String className = classWeightArray[0];
                double classWeight = Double.valueOf(classWeightArray[1]);
                int index = label.getMapping().mapString(className);
                weights[index] = classWeight;
            }
            LinkedList<Double> weightList = new LinkedList<Double>();
            for (double d : weights) {
                weightList.add(d);
            }
            this.log(this.getName() + ": used class weights --> " + weightList);
        }
        return weights;
    }

    @Override
    public List<PerformanceCriterion> getCriteria() {
        int i;
        LinkedList<PerformanceCriterion> performanceCriteria = new LinkedList<PerformanceCriterion>();
        for (i = 0; i < MultiClassificationPerformance.NAMES.length; ++i) {
            performanceCriteria.add(new MultiClassificationPerformance(i));
        }
        for (i = 0; i < WeightedMultiClassPerformance.NAMES.length; ++i) {
            performanceCriteria.add(new WeightedMultiClassPerformance(i));
        }
        for (i = 0; i < RankCorrelation.NAMES.length; ++i) {
            performanceCriteria.add(new RankCorrelation(i));
        }
        for (i = 0; i < SIMPLE_CRITERIA_CLASSES.length; ++i) {
            try {
                performanceCriteria.add((PerformanceCriterion)SIMPLE_CRITERIA_CLASSES[i].newInstance());
                continue;
            }
            catch (InstantiationException e) {
                LogService.getGlobal().logError("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ". Skipping...");
                continue;
            }
            catch (IllegalAccessException e) {
                LogService.getGlobal().logError("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ". Skipping...");
            }
        }
        return performanceCriteria;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeList(PARAMETER_CLASS_WEIGHTS, "The weights for all classes (first column: class name, second column: weight), empty: using 1 for all classes.", (ParameterType)new ParameterTypeString("class_name", "The name of the class."), (ParameterType)new ParameterTypeDouble("weight", "The weight for this class.", 0.0, Double.POSITIVE_INFINITY, 1.0)));
        return types;
    }

    @Override
    protected boolean canEvaluate(int valueType) {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 1);
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case BINOMINAL_LABEL: 
            case POLYNOMINAL_LABEL: {
                return true;
            }
            case NUMERICAL_LABEL: 
            case ONE_CLASS_LABEL: {
                return false;
            }
            case POLYNOMINAL_ATTRIBUTES: 
            case BINOMINAL_ATTRIBUTES: 
            case NUMERICAL_ATTRIBUTES: 
            case WEIGHTED_EXAMPLES: 
            case MISSING_VALUES: {
                return true;
            }
        }
        return false;
    }
}

