/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.operator.performance.PerformanceComparator;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.Averagable;
import com.rapidminer.tools.math.AverageVector;
import java.util.HashMap;
import java.util.Map;

public class PerformanceVector
extends AverageVector {
    private static final long serialVersionUID = 3123587140049371098L;
    public static final String MAIN_CRITERION_FIRST = "first";
    private Map<String, Double> currentValues = null;
    private PerformanceComparator comparator = new DefaultComparator();
    private String mainCriterion = null;

    public void setComparator(PerformanceComparator comparator) {
        this.comparator = comparator;
    }

    public void addCriterion(PerformanceCriterion crit) {
        PerformanceCriterion pc = this.getCriterion(crit.getName());
        if (pc != null) {
            this.removeAveragable(pc);
            LogService.getGlobal().log("Performance criterion '" + crit.getName() + "' was already part of performance vector. Overwritten...", 5);
        }
        this.addAveragable(crit);
    }

    public PerformanceCriterion getCriterion(int index) {
        return (PerformanceCriterion)this.getAveragable(index);
    }

    public PerformanceCriterion getCriterion(String name) {
        return (PerformanceCriterion)this.getAveragable(name);
    }

    public String[] getCriteriaNames() {
        String[] criteriaNames = new String[this.getSize()];
        for (int i = 0; i < criteriaNames.length; ++i) {
            criteriaNames[i] = this.getCriterion(i).getName();
        }
        return criteriaNames;
    }

    public void setMainCriterionName(String mcName) {
        if (!mcName.equals(MAIN_CRITERION_FIRST) && this.getAveragable(mcName) == null) {
            LogService.getGlobal().log("Main criterion not found: '" + mcName + "'.", 6);
        }
        this.mainCriterion = mcName;
    }

    public PerformanceCriterion getMainCriterion() {
        if (this.mainCriterion == null) {
            return (PerformanceCriterion)this.getAveragable(0);
        }
        PerformanceCriterion pc = (PerformanceCriterion)this.getAveragable(this.mainCriterion);
        if (pc == null) {
            return (PerformanceCriterion)this.getAveragable(0);
        }
        return pc;
    }

    public int compareTo(Object o) {
        double result = this.comparator.compare(this, (PerformanceVector)o);
        if (result < 0.0) {
            return -1;
        }
        if (result > 0.0) {
            return 1;
        }
        return 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PerformanceVector av = new PerformanceVector();
        for (int i = 0; i < this.size(); ++i) {
            Averagable avg = this.getAveragable(i);
            av.addAveragable((Averagable)avg.clone());
        }
        return av;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(Tools.getLineSeparator() + "PerformanceVector [");
        for (int i = 0; i < this.size(); ++i) {
            Averagable avg = this.getAveragable(i);
            if (this.mainCriterion != null && avg.getName().equals(this.mainCriterion)) {
                result.append(Tools.getLineSeparator() + "*****");
            } else {
                result.append(Tools.getLineSeparator() + "-----");
            }
            result.append(avg);
        }
        result.append(Tools.getLineSeparator() + "]");
        return result.toString();
    }

    public String getExtension() {
        return "per";
    }

    public String getFileDescription() {
        return "performance vector file";
    }

    @Override
    public void initWriting() {
        this.currentValues = new HashMap<String, Double>();
        for (int i = 0; i < this.size(); ++i) {
            Averagable averagable = this.getAveragable(i);
            this.currentValues.put(averagable.getName(), averagable.getAverage());
        }
    }

    public static class DefaultComparator
    implements PerformanceComparator {
        private static final long serialVersionUID = 8632060851821885142L;

        @Override
        public int compare(PerformanceVector av1, PerformanceVector av2) {
            return av1.getMainCriterion().compareTo(av2.getMainCriterion());
        }
    }
}

