/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.Averagable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class MultiClassificationPerformance
extends MeasuredPerformance {
    private static final long serialVersionUID = 3068421566038331525L;
    public static final int UNDEFINED = -1;
    public static final int ACCURACY = 0;
    public static final int ERROR = 1;
    public static final int KAPPA = 2;
    public static final String[] NAMES = new String[]{"accuracy", "classification_error", "kappa"};
    public static final String[] DESCRIPTIONS = new String[]{"Relative number of correctly classified examples", "Relative number of misclassified examples", "The kappa statistics for the classification"};
    private double[][] counter;
    private String[] classNames;
    private Map<String, Integer> classNameMap = new HashMap<String, Integer>();
    private Attribute labelAttribute;
    private Attribute predictedLabelAttribute;
    private Attribute weightAttribute;
    private int type = 0;

    public MultiClassificationPerformance() {
        this(-1);
    }

    public MultiClassificationPerformance(int type) {
        this.type = type;
    }

    public MultiClassificationPerformance(MultiClassificationPerformance m) {
        super(m);
        int i;
        this.type = m.type;
        this.classNames = new String[m.classNames.length];
        for (i = 0; i < this.classNames.length; ++i) {
            this.classNames[i] = m.classNames[i];
            this.classNameMap.put(this.classNames[i], i);
        }
        this.counter = new double[m.counter.length][m.counter.length];
        for (i = 0; i < this.counter.length; ++i) {
            for (int j = 0; j < this.counter[i].length; ++j) {
                this.counter[i][j] = m.counter[i][j];
            }
        }
        this.labelAttribute = (Attribute)m.labelAttribute.clone();
        this.predictedLabelAttribute = (Attribute)m.predictedLabelAttribute.clone();
        if (m.weightAttribute != null) {
            this.weightAttribute = (Attribute)m.weightAttribute.clone();
        }
    }

    public static MultiClassificationPerformance newInstance(String name) {
        for (int i = 0; i < NAMES.length; ++i) {
            if (!NAMES[i].equals(name)) continue;
            return new MultiClassificationPerformance(i);
        }
        return null;
    }

    @Override
    public double getExampleCount() {
        double total = 0.0;
        for (int i = 0; i < this.counter.length; ++i) {
            for (int j = 0; j < this.counter[i].length; ++j) {
                total += this.counter[i][j];
            }
        }
        return total;
    }

    @Override
    public void startCounting(ExampleSet eSet, boolean useExampleWeights) throws OperatorException {
        super.startCounting(eSet, useExampleWeights);
        this.labelAttribute = eSet.getAttributes().getLabel();
        if (!this.labelAttribute.isNominal()) {
            throw new UserError(null, 101, "calculation of classification performance criteria", this.labelAttribute.getName());
        }
        this.predictedLabelAttribute = eSet.getAttributes().getPredictedLabel();
        if (this.predictedLabelAttribute == null || !this.predictedLabelAttribute.isNominal()) {
            throw new UserError(null, 101, "calculation of classification performance criteria", "predicted label attribute");
        }
        if (useExampleWeights) {
            this.weightAttribute = eSet.getAttributes().getWeight();
        }
        List<String> labelValues = this.labelAttribute.getMapping().getValues();
        List<String> predictedLabelValues = this.predictedLabelAttribute.getMapping().getValues();
        LinkedHashSet<String> unionedMapping = new LinkedHashSet<String>(labelValues);
        unionedMapping.addAll(predictedLabelValues);
        this.counter = new double[unionedMapping.size()][unionedMapping.size()];
        this.classNames = new String[unionedMapping.size()];
        int n = 0;
        Iterator i$ = unionedMapping.iterator();
        while (i$.hasNext()) {
            String labelValue;
            this.classNames[n] = labelValue = (String)i$.next();
            this.classNameMap.put(this.classNames[n], n);
            ++n;
        }
    }

    @Override
    public void countExample(Example example) {
        int label = this.classNameMap.get(example.getNominalValue(this.labelAttribute));
        int plabel = this.classNameMap.get(example.getNominalValue(this.predictedLabelAttribute));
        double weight = 1.0;
        if (this.weightAttribute != null) {
            weight = example.getValue(this.weightAttribute);
        }
        double[] dArray = this.counter[label];
        int n = plabel;
        dArray[n] = dArray[n] + weight;
    }

    @Override
    public double getMikroAverage() {
        double diagonal = 0.0;
        double total = 0.0;
        for (int i = 0; i < this.counter.length; ++i) {
            diagonal += this.counter[i][i];
            for (int j = 0; j < this.counter[i].length; ++j) {
                total += this.counter[i][j];
            }
        }
        if (total == 0.0) {
            return Double.NaN;
        }
        double accuracy = diagonal / total;
        switch (this.type) {
            case 0: {
                return accuracy;
            }
            case 1: {
                return 1.0 - accuracy;
            }
            case 2: {
                double pa = accuracy;
                double pe = 0.0;
                for (int i = 0; i < this.counter.length; ++i) {
                    double row = 0.0;
                    double column = 0.0;
                    for (int j = 0; j < this.counter[i].length; ++j) {
                        row += this.counter[i][j];
                        column += this.counter[j][i];
                    }
                    pe += row * column / (total * total);
                }
                return (pa - pe) / (1.0 - pe);
            }
        }
        throw new RuntimeException("Unknown type " + this.type + " for multi class performance criterion!");
    }

    @Override
    public boolean formatPercent() {
        return this.type != 2;
    }

    @Override
    public double getMikroVariance() {
        return Double.NaN;
    }

    @Override
    public String getName() {
        return NAMES[this.type];
    }

    @Override
    public String getDescription() {
        return DESCRIPTIONS[this.type];
    }

    @Override
    public double getFitness() {
        if (this.type == 1) {
            return 1.0 - this.getAverage();
        }
        return this.getAverage();
    }

    @Override
    public double getMaxFitness() {
        return 1.0;
    }

    @Override
    public void buildSingleAverage(Averagable performance) {
        MultiClassificationPerformance other = (MultiClassificationPerformance)performance;
        for (int i = 0; i < this.counter.length; ++i) {
            for (int j = 0; j < this.counter[i].length; ++j) {
                double[] dArray = this.counter[i];
                int n = j;
                dArray[n] = dArray[n] + other.counter[i][j];
            }
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuffer result = new StringBuffer(super.toString());
        result.append(Tools.getLineSeparator() + "ConfusionMatrix:" + Tools.getLineSeparator() + "True:");
        for (i = 0; i < this.counter.length; ++i) {
            result.append("\t" + this.classNames[i]);
        }
        for (i = 0; i < this.counter.length; ++i) {
            result.append(Tools.getLineSeparator() + this.classNames[i] + ":");
            for (int j = 0; j < this.counter[i].length; ++j) {
                result.append("\t" + Tools.formatIntegerIfPossible(this.counter[j][i]));
            }
        }
        return result.toString();
    }

    public String getTitle() {
        return super.toString();
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public double[][] getCounter() {
        return this.counter;
    }
}

