/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.operator.performance.MinMaxCriterion;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.List;

public class MinMaxWrapper
extends Operator {
    public static final String PARAMETER_MINIMUM_WEIGHT = "minimum_weight";
    private InputPort performanceInput = this.getInputPorts().createPort("performance vector", PerformanceVector.class);
    private OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance vector");

    public MinMaxWrapper(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.performanceInput, this.performanceOutput);
    }

    @Override
    public void doWork() throws OperatorException {
        PerformanceVector performanceVector = (PerformanceVector)this.performanceInput.getData();
        PerformanceVector result = new PerformanceVector();
        for (int i = 0; i < performanceVector.size(); ++i) {
            PerformanceCriterion crit = performanceVector.getCriterion(i);
            if (!(crit instanceof MeasuredPerformance)) continue;
            result.addCriterion(new MinMaxCriterion((MeasuredPerformance)crit, this.getParameterAsDouble(PARAMETER_MINIMUM_WEIGHT)));
        }
        result.setMainCriterionName(performanceVector.getMainCriterion().getName());
        this.performanceOutput.deliver(result);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_MINIMUM_WEIGHT, "Defines the weight for the minimum fitness agains the average fitness", 0.0, 1.0, 1.0);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

