/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;
import java.util.Iterator;

public class Margin
extends MeasuredPerformance {
    private static final long serialVersionUID = -2987795640706342168L;
    private double margin = Double.NaN;
    private double counter = 1.0;

    public Margin() {
    }

    public Margin(Margin m) {
        super(m);
        this.margin = m.margin;
        this.counter = m.counter;
    }

    @Override
    public void startCounting(ExampleSet exampleSet, boolean useExampleWeights) throws OperatorException {
        super.startCounting(exampleSet, useExampleWeights);
        Iterator reader = exampleSet.iterator();
        this.margin = 1.0;
        Attribute labelAttr = exampleSet.getAttributes().getLabel();
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            String trueLabel = example.getNominalValue(labelAttr);
            double confidence = example.getConfidence(trueLabel);
            this.margin = Math.min(this.margin, confidence);
        }
    }

    @Override
    public void countExample(Example example) {
    }

    @Override
    public double getExampleCount() {
        return this.counter;
    }

    @Override
    public double getMikroVariance() {
        return Double.NaN;
    }

    @Override
    public double getMikroAverage() {
        return this.margin / this.counter;
    }

    @Override
    public double getFitness() {
        return this.getAverage();
    }

    @Override
    public String getName() {
        return "margin";
    }

    @Override
    public String getDescription() {
        return "The margin of a classifier, defined as the minimal confidence for the correct label.";
    }

    @Override
    public void buildSingleAverage(Averagable performance) {
        Margin other = (Margin)performance;
        this.margin += other.margin;
        this.counter += other.counter;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

