/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;

public class MDLCriterion
extends MeasuredPerformance {
    private static final long serialVersionUID = -5023462349084083154L;
    public static final String[] DIRECTIONS = new String[]{"minimization", "maximization"};
    public static final int MINIMIZATION = 0;
    public static final int MAXIMIZATION = 1;
    private int length;
    private double counter = 1.0;
    private int direction = 0;

    public MDLCriterion() {
    }

    public MDLCriterion(int direction) {
        this();
        this.direction = direction;
    }

    public MDLCriterion(MDLCriterion mdl) {
        super(mdl);
        this.length = mdl.length;
        this.counter = mdl.counter;
        this.direction = mdl.direction;
    }

    @Override
    public String getName() {
        return "number_of_attributes";
    }

    @Override
    public String getDescription() {
        return "Measures the length of an example set (i.e. the number of attributes).";
    }

    @Override
    public void startCounting(ExampleSet eSet, boolean useExampleWeights) throws OperatorException {
        super.startCounting(eSet, useExampleWeights);
        this.length = eSet instanceof AttributeWeightedExampleSet ? ((AttributeWeightedExampleSet)eSet).getNumberOfUsedAttributes() : eSet.getAttributes().size();
    }

    @Override
    public double getExampleCount() {
        return this.counter;
    }

    @Override
    public void countExample(Example example) {
    }

    @Override
    public double getFitness() {
        switch (this.direction) {
            case 0: {
                return -1.0 * (double)this.length / this.counter;
            }
            case 1: {
                return (double)this.length / this.counter;
            }
        }
        return Double.NaN;
    }

    @Override
    public double getMikroAverage() {
        return (double)this.length / this.counter;
    }

    @Override
    public double getMikroVariance() {
        return Double.NaN;
    }

    @Override
    public void buildSingleAverage(Averagable averagable) {
        MDLCriterion other = (MDLCriterion)averagable;
        this.length += other.length;
        this.counter += 1.0;
    }
}

