/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;
import java.util.Iterator;

public class LogisticLoss
extends MeasuredPerformance {
    private static final long serialVersionUID = -2987795640706342168L;
    private double loss = Double.NaN;
    private double counter = 0.0;

    public LogisticLoss() {
    }

    public LogisticLoss(LogisticLoss m) {
        super(m);
        this.loss = m.loss;
        this.counter = m.counter;
    }

    @Override
    public void startCounting(ExampleSet exampleSet, boolean useExampleWeights) throws OperatorException {
        super.startCounting(exampleSet, useExampleWeights);
        Iterator reader = exampleSet.iterator();
        this.loss = 0.0;
        Attribute labelAttr = exampleSet.getAttributes().getLabel();
        Attribute weightAttr = null;
        if (useExampleWeights) {
            weightAttr = exampleSet.getAttributes().getWeight();
        }
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            String trueLabel = example.getNominalValue(labelAttr);
            double confidence = example.getConfidence(trueLabel);
            double weight = 1.0;
            if (weightAttr != null) {
                weight = example.getValue(weightAttr);
            }
            double currentMargin = weight * Math.log(1.0 + Math.exp(-1.0 * confidence));
            this.loss += currentMargin;
        }
        this.loss /= (double)exampleSet.size();
    }

    @Override
    public void countExample(Example example) {
    }

    @Override
    public double getExampleCount() {
        return this.counter;
    }

    @Override
    public double getMikroVariance() {
        return Double.NaN;
    }

    @Override
    public double getMikroAverage() {
        return this.loss / this.counter;
    }

    @Override
    public double getMaxFitness() {
        return 0.0;
    }

    @Override
    public double getFitness() {
        return -1.0 * this.getAverage();
    }

    @Override
    public String getName() {
        return "logistic_loss";
    }

    @Override
    public String getDescription() {
        return "The logistic loss of a classifier, defined as the average of ln(1 + exp(- [confidence of the correct class]))";
    }

    @Override
    public void buildSingleAverage(Averagable performance) {
        LogisticLoss other = (LogisticLoss)performance;
        this.loss += other.loss;
        this.counter += other.counter;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

