/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.operator.performance.SimpleCriterion;
import com.rapidminer.tools.Tools;

public class LenientRelativeError
extends SimpleCriterion {
    private static final long serialVersionUID = -6816726234908353254L;

    public LenientRelativeError() {
    }

    public LenientRelativeError(LenientRelativeError sc) {
        super(sc);
    }

    @Override
    public double countExample(double label, double predictedLabel) {
        double diff = Math.abs(label - predictedLabel);
        double absLabel = Math.abs(label);
        double absPrediction = Math.abs(predictedLabel);
        if (Tools.isZero(diff)) {
            return 0.0;
        }
        return diff / Math.max(absLabel, absPrediction);
    }

    @Override
    public boolean formatPercent() {
        return true;
    }

    @Override
    public String getName() {
        return "relative_error_lenient";
    }

    @Override
    public String getDescription() {
        return "Average lenient relative error (average of absolute deviation of the prediction from the actual value divided by maximum of the actual value and the prediction)";
    }
}

