/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.tools.math.Averagable;

public class EstimatedPerformance
extends PerformanceCriterion {
    private static final long serialVersionUID = 2451922700464241674L;
    private String name;
    private double value;
    private double exampleCount = 1.0;
    private boolean minimizeForFitness;

    public EstimatedPerformance() {
    }

    public EstimatedPerformance(EstimatedPerformance ep) {
        super(ep);
        this.name = ep.name;
        this.minimizeForFitness = ep.minimizeForFitness;
        this.exampleCount = ep.exampleCount;
        this.value = ep.value;
    }

    public EstimatedPerformance(String name, double value, int numberOfExamples, boolean minimizeForFitness) {
        this.name = name;
        this.setMikroAverage(value, numberOfExamples);
        this.minimizeForFitness = minimizeForFitness;
    }

    @Override
    public double getExampleCount() {
        return this.exampleCount;
    }

    @Override
    public double getMikroVariance() {
        return Double.NaN;
    }

    public void setMikroAverage(double value, double numberOfExamples) {
        this.value = value * numberOfExamples;
        this.exampleCount = numberOfExamples;
    }

    @Override
    public double getMikroAverage() {
        return this.value / this.exampleCount;
    }

    @Override
    public double getFitness() {
        if (this.minimizeForFitness) {
            return -1.0 * this.getAverage();
        }
        return this.getAverage();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return "The estimated performance '" + this.name + "'";
    }

    @Override
    public void buildSingleAverage(Averagable performance) {
        EstimatedPerformance other = (EstimatedPerformance)performance;
        this.exampleCount += other.exampleCount;
        this.value += other.value;
    }
}

