/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.AbstractPerformanceEvaluator;
import com.rapidminer.operator.performance.AreaUnderCurve;
import com.rapidminer.operator.performance.BinaryClassificationPerformance;
import com.rapidminer.operator.performance.MultiClassificationPerformance;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import java.util.LinkedList;
import java.util.List;

public class BinominalClassificationPerformanceEvaluator
extends AbstractPerformanceEvaluator {
    private static final Class[] SIMPLE_CRITERIA_CLASSES = new Class[]{AreaUnderCurve.Optimistic.class, AreaUnderCurve.Optimistic.class, AreaUnderCurve.Neutral.class, AreaUnderCurve.Pessimistic.class};

    public BinominalClassificationPerformanceEvaluator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected void checkCompatibility(ExampleSet exampleSet) throws OperatorException {
        Tools.isLabelled(exampleSet);
        Tools.isNonEmpty(exampleSet);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (!label.isNominal()) {
            throw new UserError((Operator)this, 101, "the calculation of performance criteria for binominal classification tasks", label.getName());
        }
        if (label.getMapping().size() != 2) {
            throw new UserError((Operator)this, 114, "the calculation of performance criteria for binominal classification tasks", label.getName());
        }
    }

    @Override
    protected double[] getClassWeights(Attribute label) throws UndefinedParameterError {
        return null;
    }

    @Override
    public List<PerformanceCriterion> getCriteria() {
        int i;
        LinkedList<PerformanceCriterion> performanceCriteria = new LinkedList<PerformanceCriterion>();
        for (i = 0; i < MultiClassificationPerformance.NAMES.length; ++i) {
            performanceCriteria.add(new MultiClassificationPerformance(i));
        }
        for (i = 0; i < SIMPLE_CRITERIA_CLASSES.length; ++i) {
            try {
                performanceCriteria.add((PerformanceCriterion)SIMPLE_CRITERIA_CLASSES[i].newInstance());
                continue;
            }
            catch (InstantiationException e) {
                LogService.getGlobal().logError("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ". Skipping...");
                continue;
            }
            catch (IllegalAccessException e) {
                LogService.getGlobal().logError("Cannot instantiate " + SIMPLE_CRITERIA_CLASSES[i] + ". Skipping...");
            }
        }
        for (i = 0; i < BinaryClassificationPerformance.NAMES.length; ++i) {
            performanceCriteria.add(new BinaryClassificationPerformance(i));
        }
        return performanceCriteria;
    }

    @Override
    protected boolean canEvaluate(int valueType) {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 6);
    }

    @Override
    public boolean supportsCapability(OperatorCapability capability) {
        switch (capability) {
            case BINOMINAL_LABEL: {
                return true;
            }
            case POLYNOMINAL_LABEL: 
            case NUMERICAL_LABEL: 
            case ONE_CLASS_LABEL: {
                return false;
            }
            case POLYNOMINAL_ATTRIBUTES: 
            case BINOMINAL_ATTRIBUTES: 
            case NUMERICAL_ATTRIBUTES: 
            case WEIGHTED_EXAMPLES: 
            case MISSING_VALUES: {
                return true;
            }
        }
        return false;
    }
}

